/*
 * Decompiled with CFR 0.152.
 */
package com.android.usbserial.client;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.android.usbserial.client.OnUsbSerialDeviceListener;
import com.android.usbserial.driver.ProbeTable;
import com.android.usbserial.driver.UsbSerialDriver;
import com.android.usbserial.driver.UsbSerialPort;
import com.android.usbserial.driver.UsbSerialProber;
import com.android.usbserial.util.SerialInputOutputManager;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.dal.communication.OnUsbSerialStateListener;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgTestWorkModeInit;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidUsbSerialClient
extends CommunicationInterface
implements SerialInputOutputManager.Listener {
    private static final String ACTION_USB_PERMISSION = "com.android.gx.USB_PERMISSION";
    private UsbManager mUsbManager;
    private UsbSerialPort usbSerialPort;
    private SerialInputOutputManager mSerialIoManager;
    private Handler mHandler;
    public OnUsbSerialDeviceListener deviceListener;
    public OnUsbSerialStateListener stateListener;
    private Context mContext;
    private int mBaudRate = 115200;
    private int writeTimeout = 2000;
    private String mUsbName;
    private boolean isDtr;
    private String initParam;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (AndroidUsbSerialClient.ACTION_USB_PERMISSION.equals(action)) {
                context.unregisterReceiver((BroadcastReceiver)this);
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false) && device != null) {
                        AndroidUsbSerialClient.this.openDevice();
                    } else {
                        AndroidUsbSerialClient.this.onConnectFailed();
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mUsbStateChange = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                if (AndroidUsbSerialClient.this.stateListener != null) {
                    AndroidUsbSerialClient.this.stateListener.onDeviceAttached();
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && AndroidUsbSerialClient.this.stateListener != null) {
                AndroidUsbSerialClient.this.stateListener.onDeviceDetached();
            }
        }
    };

    public boolean isDtr() {
        return this.isDtr;
    }

    public void setDtr(boolean dtr) {
        this.isDtr = dtr;
    }

    public UsbDevice getUsbDevice() {
        return this.usbSerialPort.getDriver().getDevice();
    }

    public int getBaudRate() {
        return this.mBaudRate;
    }

    public void setBaudRate(int mBaudRate) {
        this.mBaudRate = mBaudRate;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public String getUsbName() {
        return this.mUsbName;
    }

    public void setmUsbName(String mUsbName) {
        this.mUsbName = mUsbName;
    }

    public static Map<String, AndroidUsbSerialClient> getUsbDevicesMap(Context context) {
        UsbManager mUsbManager = (UsbManager)context.getApplicationContext().getSystemService("usb");
        if (mUsbManager == null) {
            return null;
        }
        List<UsbSerialDriver> drivers = UsbSerialProber.getDefaultProber().findAllDrivers(mUsbManager);
        HashMap<String, AndroidUsbSerialClient> driverMap = new HashMap<String, AndroidUsbSerialClient>();
        for (UsbSerialDriver driver : drivers) {
            List<UsbSerialPort> ports = driver.getPorts();
            for (UsbSerialPort port : ports) {
                UsbDevice device = port.getDriver().getDevice();
                String s = driver.getDriverName() + "_vid_" + device.getVendorId() + "&pid_" + device.getProductId() + "_" + device.getDeviceId();
                AndroidUsbSerialClient usbSerialClient = new AndroidUsbSerialClient(port, context, mUsbManager, s);
                driverMap.put(s, usbSerialClient);
            }
        }
        return driverMap;
    }

    public static Map<String, AndroidUsbSerialClient> getUsbDevicesMap(Context context, int vid, int pid) {
        UsbManager mUsbManager = (UsbManager)context.getApplicationContext().getSystemService("usb");
        if (mUsbManager == null) {
            return null;
        }
        List<UsbSerialDriver> drivers = UsbSerialProber.getDefaultProber().findAllDrivers(mUsbManager);
        HashMap<String, AndroidUsbSerialClient> driverMap = new HashMap<String, AndroidUsbSerialClient>();
        for (UsbSerialDriver driver : drivers) {
            List<UsbSerialPort> ports = driver.getPorts();
            for (UsbSerialPort port : ports) {
                UsbDevice device = port.getDriver().getDevice();
                if (device.getVendorId() != vid || device.getProductId() != pid) continue;
                String s = driver.getDriverName() + "_vid_" + device.getVendorId() + "&pid_" + device.getProductId() + "_" + device.getDeviceId();
                AndroidUsbSerialClient usbSerialClient = new AndroidUsbSerialClient(port, context, mUsbManager, s);
                driverMap.put(s, usbSerialClient);
            }
        }
        return driverMap;
    }

    public static Map<String, AndroidUsbSerialClient> getOtherUsbDevicesMap(Context context, Map<Integer, Integer> vid_pid_map, Class<? extends UsbSerialDriver> driverClass) {
        UsbManager mUsbManager = (UsbManager)context.getApplicationContext().getSystemService("usb");
        if (mUsbManager == null) {
            return null;
        }
        ProbeTable customTable = new ProbeTable();
        if (vid_pid_map != null) {
            for (Integer key : vid_pid_map.keySet()) {
                customTable.addProduct(key, vid_pid_map.get(key), driverClass);
            }
        }
        UsbSerialProber prober = new UsbSerialProber(customTable);
        List<UsbSerialDriver> drivers = prober.findAllDrivers(mUsbManager);
        HashMap<String, AndroidUsbSerialClient> driverMap = new HashMap<String, AndroidUsbSerialClient>();
        for (UsbSerialDriver driver : drivers) {
            List<UsbSerialPort> ports = driver.getPorts();
            for (UsbSerialPort port : ports) {
                UsbDevice device = port.getDriver().getDevice();
                String s = driver.getDriverName() + "_vid_" + device.getVendorId() + "&pid_" + device.getProductId() + "_" + device.getDeviceId();
                AndroidUsbSerialClient usbSerialClient = new AndroidUsbSerialClient(port, context, mUsbManager, s);
                driverMap.put(s, usbSerialClient);
            }
        }
        return driverMap;
    }

    public static List<AndroidUsbSerialClient> getUsbDevicesList(Context context) {
        Map<String, AndroidUsbSerialClient> usbDevicesMap = AndroidUsbSerialClient.getUsbDevicesMap(context);
        if (usbDevicesMap == null) {
            return null;
        }
        return new ArrayList<AndroidUsbSerialClient>(usbDevicesMap.values());
    }

    public static List<AndroidUsbSerialClient> getUsbDevicesList(Context context, int vid, int pid) {
        Map<String, AndroidUsbSerialClient> usbDevicesMap = AndroidUsbSerialClient.getUsbDevicesMap(context, vid, pid);
        if (usbDevicesMap == null) {
            return null;
        }
        return new ArrayList<AndroidUsbSerialClient>(usbDevicesMap.values());
    }

    private AndroidUsbSerialClient(UsbSerialPort serialPort, Context context, UsbManager usbManager, String usbName) {
        this.usbSerialPort = serialPort;
        this.mContext = context;
        this.mUsbManager = usbManager;
        this.mUsbName = usbName;
    }

    private void hasPermission() {
        this.mHandler = new Handler(Looper.getMainLooper());
        if (!this.mUsbManager.hasPermission(this.getUsbDevice())) {
            Intent intent = new Intent(ACTION_USB_PERMISSION);
            intent.setPackage(this.mContext.getPackageName());
            PendingIntent permissionIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x2000000) : PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            if (Build.VERSION.SDK_INT >= 34) {
                this.mContext.registerReceiver(this.mUsbReceiver, filter, 4);
            } else {
                this.mContext.registerReceiver(this.mUsbReceiver, filter);
            }
            this.mUsbManager.requestPermission(this.getUsbDevice(), permissionIntent);
        } else {
            this.openDevice();
        }
    }

    private void openDevice() {
        UsbDeviceConnection connection = this.mUsbManager.openDevice(this.getUsbDevice());
        if (connection == null) {
            this.onConnectFailed();
            return;
        }
        try {
            this.usbSerialPort.open(connection);
            this.usbSerialPort.setParameters(this.mBaudRate, 8, 1, 0);
            this.usbSerialPort.setDTR(this.isDtr);
            this.mSerialIoManager = new SerialInputOutputManager(this.usbSerialPort, this);
            this.keepReceived = true;
            this.mSerialIoManager.start();
            this.startProcess();
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (AndroidUsbSerialClient.this.deviceListener != null) {
                        if (AndroidUsbSerialClient.this.initParam != null) {
                            AndroidUsbSerialClient.this.send(new MsgTestWorkModeInit(AndroidUsbSerialClient.this.initParam, 0));
                        }
                        AndroidUsbSerialClient.this.deviceListener.onDeviceConnected();
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void onConnectFailed() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AndroidUsbSerialClient.this.deviceListener != null) {
                    AndroidUsbSerialClient.this.deviceListener.onDeviceConnectFailed();
                }
            }
        });
    }

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        return false;
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    @Override
    public boolean open(String param) {
        if (!param.equals("")) {
            this.initParam = param;
        }
        this.hasPermission();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.keepReceived = false;
        if (this.usbSerialPort != null) {
            try {
                this.mSerialIoManager.stop();
                this.usbSerialPort.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notify();
                this.ringBuffer.Clear();
            }
        }
    }

    @Override
    public void send(byte[] data) {
        if (this.usbSerialPort != null) {
            int maxPacketSize = this.usbSerialPort.getWriteEndpoint().getMaxPacketSize();
            int pack = data.length % maxPacketSize == 0 ? data.length / maxPacketSize : data.length / maxPacketSize + 1;
            try {
                for (int i = 0; i < pack; ++i) {
                    byte[] temp = null;
                    temp = i == pack - 1 ? new byte[data.length - i * maxPacketSize] : new byte[maxPacketSize];
                    System.arraycopy(data, i * maxPacketSize, temp, 0, temp.length);
                    this.usbSerialPort.write(temp, this.writeTimeout);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void send(Message msg) {
        try {
            if (this.isRs485) {
                msg.msgType.mt_13 = "1";
                msg.rs485Address = this.getRs485Address();
            }
            msg.pack();
            this.send(msg.toBytes(this.isRs485));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewData(byte[] data) {
        try {
            Object object = this.lockRingBuffer;
            synchronized (object) {
                while (data.length + this.ringBuffer.getDataCount() > 0x100000) {
                    this.lockRingBuffer.wait(10000L);
                }
                this.ringBuffer.WriteBuffer(data, 0, data.length);
                this.lockRingBuffer.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onRunError(Exception e) {
    }

    public void registerUsbState(Context context) {
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        IntentFilter usbFilter = new IntentFilter();
        usbFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        usbFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        context.registerReceiver(this.mUsbStateChange, usbFilter);
    }

    public void unregisterState(Context context) {
        context.unregisterReceiver(this.mUsbStateChange);
    }
}

