/*
 * Decompiled with CFR 0.152.
 */
package com.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.util.Pair;
import com.android.usbserial.driver.UsbSerialDriver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProbeTable {
    private final Map<Pair<Integer, Integer>, Class<? extends UsbSerialDriver>> mVidPidProbeTable = new LinkedHashMap<Pair<Integer, Integer>, Class<? extends UsbSerialDriver>>();
    private final Map<Method, Class<? extends UsbSerialDriver>> mMethodProbeTable = new LinkedHashMap<Method, Class<? extends UsbSerialDriver>>();

    public ProbeTable addProduct(int vendorId, int productId, Class<? extends UsbSerialDriver> driverClass) {
        this.mVidPidProbeTable.put((Pair<Integer, Integer>)Pair.create((Object)vendorId, (Object)productId), driverClass);
        return this;
    }

    void addDriver(Class<? extends UsbSerialDriver> driverClass) {
        Map devices;
        Method method;
        try {
            method = driverClass.getMethod("getSupportedDevices", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            devices = (Map)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : devices.entrySet()) {
            int vendorId = (Integer)entry.getKey();
            for (int productId : (int[])entry.getValue()) {
                this.addProduct(vendorId, productId, driverClass);
            }
        }
        try {
            method = driverClass.getMethod("probe", UsbDevice.class);
            this.mMethodProbeTable.put(method, driverClass);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    public Class<? extends UsbSerialDriver> findDriver(UsbDevice usbDevice) {
        Pair pair = Pair.create((Object)usbDevice.getVendorId(), (Object)usbDevice.getProductId());
        Class<? extends UsbSerialDriver> driverClass = this.mVidPidProbeTable.get(pair);
        if (driverClass != null) {
            return driverClass;
        }
        for (Map.Entry<Method, Class<? extends UsbSerialDriver>> entry : this.mMethodProbeTable.entrySet()) {
            try {
                Method method = entry.getKey();
                Object o = method.invoke(null, usbDevice);
                if (!((Boolean)o).booleanValue()) continue;
                return entry.getValue();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

