/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal;

import com.android.usbserial.client.AndroidUsbSerialClient;
import com.gg.reader.api.dal.ClientManualResetEvent;
import com.gg.reader.api.dal.HandlerAllGpiState;
import com.gg.reader.api.dal.HandlerAntStandingWaveLog;
import com.gg.reader.api.dal.HandlerCacheDataOver;
import com.gg.reader.api.dal.HandlerDebugLog;
import com.gg.reader.api.dal.HandlerGpiOver;
import com.gg.reader.api.dal.HandlerGpiStart;
import com.gg.reader.api.dal.HandlerHeartbeatLog;
import com.gg.reader.api.dal.HandlerLightingOver;
import com.gg.reader.api.dal.HandlerOnKeyEvent;
import com.gg.reader.api.dal.HandlerOnTriggerSXEvent;
import com.gg.reader.api.dal.HandlerTag6DLog;
import com.gg.reader.api.dal.HandlerTag6DOver;
import com.gg.reader.api.dal.HandlerTag6bLog;
import com.gg.reader.api.dal.HandlerTag6bOver;
import com.gg.reader.api.dal.HandlerTagAccessLog;
import com.gg.reader.api.dal.HandlerTagEpcLog;
import com.gg.reader.api.dal.HandlerTagEpcOver;
import com.gg.reader.api.dal.HandlerTagGJbLog;
import com.gg.reader.api.dal.HandlerTagGJbOver;
import com.gg.reader.api.dal.HandlerTagGJbRn11Log;
import com.gg.reader.api.dal.HandlerTagGbLog;
import com.gg.reader.api.dal.HandlerTagGbOver;
import com.gg.reader.api.dal.HandlerTagGbSafeParam;
import com.gg.reader.api.dal.HandlerTagTLLog;
import com.gg.reader.api.dal.HandlerTagTLOver;
import com.gg.reader.api.dal.HandlerTcpDisconnected;
import com.gg.reader.api.dal.communication.AndroidPdaSerialClient;
import com.gg.reader.api.dal.communication.AndroidSerialClient;
import com.gg.reader.api.dal.communication.AndroidSerialCusClient;
import com.gg.reader.api.dal.communication.AndroidUsbHidClient;
import com.gg.reader.api.dal.communication.BleBluetoothClient;
import com.gg.reader.api.dal.communication.BluetoothClient;
import com.gg.reader.api.dal.communication.CWSerialClient;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.dal.communication.HandlerAntIdLog;
import com.gg.reader.api.dal.communication.HandlerDisconnected;
import com.gg.reader.api.dal.communication.HandlerMessageReceived;
import com.gg.reader.api.dal.communication.HandlerRevCommand;
import com.gg.reader.api.dal.communication.TcpClient;
import com.gg.reader.api.protocol.gx.LogAppAllGpiState;
import com.gg.reader.api.protocol.gx.LogAppGpiOver;
import com.gg.reader.api.protocol.gx.LogAppGpiStart;
import com.gg.reader.api.protocol.gx.LogBase6DInfo;
import com.gg.reader.api.protocol.gx.LogBase6DOver;
import com.gg.reader.api.protocol.gx.LogBase6bInfo;
import com.gg.reader.api.protocol.gx.LogBase6bOver;
import com.gg.reader.api.protocol.gx.LogBaseAccessInfo;
import com.gg.reader.api.protocol.gx.LogBaseEpcInfo;
import com.gg.reader.api.protocol.gx.LogBaseEpcOver;
import com.gg.reader.api.protocol.gx.LogBaseGJbInfo;
import com.gg.reader.api.protocol.gx.LogBaseGJbOver;
import com.gg.reader.api.protocol.gx.LogBaseGbInfo;
import com.gg.reader.api.protocol.gx.LogBaseGbOver;
import com.gg.reader.api.protocol.gx.LogBaseGbSafeParam;
import com.gg.reader.api.protocol.gx.LogBaseTLInfo;
import com.gg.reader.api.protocol.gx.LogBaseTLOver;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgAppGetCacheTagData;
import com.gg.reader.api.protocol.gx.MsgAppHeartbeat;
import com.gg.reader.api.protocol.gx.MsgTestWorkModeInit;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.GLog;
import com.gg.reader.api.utils.HexUtils;
import com.peripheral.ble.BleDevice;
import java.util.HashMap;

public class GClient {
    private CommunicationInterface ci;
    private String name;
    private String serialNumber;
    private static final int MSG_TIME_OUT = 3000;
    private HashMap<Integer, ClientManualResetEvent> dicMre = new HashMap();
    public HandlerTagEpcLog onTagEpcLog;
    public HandlerTagEpcOver onTagEpcOver;
    public HandlerTag6bLog onTag6bLog;
    public HandlerTag6bOver onTag6bOver;
    public HandlerTagGbLog onTagGbLog;
    public HandlerTagGbOver onTagGbOver;
    public HandlerTagGJbLog onTagGJbLog;
    public HandlerTagGJbOver onTagGJbOver;
    public HandlerTagGJbRn11Log onTagGJbRn11Log;
    public HandlerTagGbSafeParam onTagGbSafeParam;
    public HandlerGpiStart onGpiStart;
    public HandlerGpiOver onGpiOver;
    public HandlerAllGpiState onAllGpiState;
    public HandlerHeartbeatLog onHeartbeatLog;
    public HandlerTagTLLog onTagTLog;
    public HandlerTagTLOver onTagTLOver;
    public HandlerTag6DLog onTag6DLog;
    public HandlerTag6DOver onTag6DOver;
    public HandlerTagAccessLog onAccessLog;
    public HandlerTcpDisconnected onDisconnected;
    public HandlerAntIdLog onAntIdLog;
    public HandlerAntStandingWaveLog onAntStandingWaveLog;
    public HandlerDebugLog debugLog;
    public HandlerCacheDataOver cacheDataOver;
    public HandlerOnKeyEvent onKeyEvent;
    public HandlerLightingOver onLightingOver;
    public HandlerOnTriggerSXEvent onTriggerSXEvent;
    private boolean isPrint = true;
    private boolean serialBlock = false;
    private String initParam;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getInitParam() {
        return this.initParam;
    }

    public void setInitParam(String initParam) {
        this.initParam = initParam;
    }

    public int getConnectType() {
        if (null == this.ci) {
            return 255;
        }
        return this.ci.getConnectType();
    }

    public void setSendHeartBeat(boolean _isSendHeartbeat) {
        if (null != this.ci) {
            this.ci._isSendHeartbeat = _isSendHeartbeat;
        }
    }

    public void setHeartBeatTimeout(int timeout) {
        if (null != this.ci) {
            this.ci.heartbeatTimeout = timeout;
        }
    }

    public void setPrint(boolean print) {
        this.isPrint = print;
    }

    public void setSerialBlock(boolean block) {
        this.serialBlock = block;
    }

    public void setOnRevCommandListener(HandlerRevCommand revCommand) {
        if (this.ci != null) {
            this.ci.onRevCommand = revCommand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagEpcLogEvent(LogBaseEpcInfo msg) {
        block6: {
            try {
                if (this.onTagEpcLog == null) break block6;
                HandlerTagEpcLog handlerTagEpcLog = this.onTagEpcLog;
                synchronized (handlerTagEpcLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagEpcLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagEpcOverEvent(LogBaseEpcOver msg) {
        block7: {
            try {
                if (this.onTagEpcOver == null) break block7;
                HandlerTagEpcOver handlerTagEpcOver = this.onTagEpcOver;
                synchronized (handlerTagEpcOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagEpcOver.log(this.name, msg);
                    if (this.debugLog != null) {
                        this.debugLog.receiveDebugLog("6c-[" + msg.getRtMsg() + "]");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTag6bLogEvent(LogBase6bInfo msg) {
        block6: {
            try {
                if (this.onTag6bLog == null) break block6;
                HandlerTag6bLog handlerTag6bLog = this.onTag6bLog;
                synchronized (handlerTag6bLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTag6bLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTag6bOverEvent(LogBase6bOver msg) {
        block7: {
            try {
                if (this.onTag6bOver == null) break block7;
                HandlerTag6bOver handlerTag6bOver = this.onTag6bOver;
                synchronized (handlerTag6bOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTag6bOver.log(this.name, msg);
                    if (this.debugLog != null) {
                        this.debugLog.receiveDebugLog("6b-[" + msg.getRtMsg() + "]");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGbLogEvent(LogBaseGbInfo msg) {
        block6: {
            try {
                if (this.onTagGbLog == null) break block6;
                HandlerTagGbLog handlerTagGbLog = this.onTagGbLog;
                synchronized (handlerTagGbLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagGbLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGbOverEvent(LogBaseGbOver msg) {
        block7: {
            try {
                if (this.onTagGbOver == null) break block7;
                HandlerTagGbOver handlerTagGbOver = this.onTagGbOver;
                synchronized (handlerTagGbOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagGbOver.log(this.name, msg);
                    if (this.debugLog != null) {
                        this.debugLog.receiveDebugLog("Gb-[" + msg.getRtMsg() + "]");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagTLLogEvent(LogBaseTLInfo msg) {
        block6: {
            try {
                if (this.onTagTLog == null) break block6;
                HandlerTagTLLog handlerTagTLLog = this.onTagTLog;
                synchronized (handlerTagTLLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagTLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagTLOverEvent(LogBaseTLOver msg) {
        block7: {
            try {
                if (this.onTagTLOver == null) break block7;
                HandlerTagTLOver handlerTagTLOver = this.onTagTLOver;
                synchronized (handlerTagTLOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagTLOver.log(this.name, msg);
                    if (this.debugLog != null) {
                        this.debugLog.receiveDebugLog("TL-[" + msg.getRtMsg() + "]");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTag6DLogEvent(LogBase6DInfo msg) {
        block6: {
            try {
                if (this.onTag6DLog == null) break block6;
                HandlerTag6DLog handlerTag6DLog = this.onTag6DLog;
                synchronized (handlerTag6DLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTag6DLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTag6DOverEvent(LogBase6DOver msg) {
        block7: {
            try {
                if (this.onTag6DOver == null) break block7;
                HandlerTag6DOver handlerTag6DOver = this.onTag6DOver;
                synchronized (handlerTag6DOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTag6DOver.log(this.name, msg);
                    if (this.debugLog != null) {
                        this.debugLog.receiveDebugLog("6D-[" + msg.getRtMsg() + "]");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagAntIdEvent(int antId) {
        block5: {
            try {
                if (this.onAntIdLog == null) break block5;
                HandlerAntIdLog handlerAntIdLog = this.onAntIdLog;
                synchronized (handlerAntIdLog) {
                    this.onAntIdLog.log(this.name, antId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGJbLogEvent(LogBaseGJbInfo msg) {
        block6: {
            try {
                if (this.onTagGJbLog == null) break block6;
                HandlerTagGJbLog handlerTagGJbLog = this.onTagGJbLog;
                synchronized (handlerTagGJbLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagGJbLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGJbOverEvent(LogBaseGJbOver msg) {
        block7: {
            try {
                if (this.onTagGJbOver == null) break block7;
                HandlerTagGJbOver handlerTagGJbOver = this.onTagGJbOver;
                synchronized (handlerTagGJbOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagGJbOver.log(this.name, msg);
                    if (this.debugLog != null) {
                        this.debugLog.receiveDebugLog("GJb-[" + msg.getRtMsg() + "]");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGJbRn11LogEvent(byte[] data) {
        block5: {
            try {
                if (this.onTagGJbRn11Log == null) break block5;
                HandlerTagGJbRn11Log handlerTagGJbRn11Log = this.onTagGJbRn11Log;
                synchronized (handlerTagGJbRn11Log) {
                    this.onTagGJbRn11Log.log(this.name, data);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGbSafeParamEvent(LogBaseGbSafeParam msg) {
        block5: {
            try {
                if (this.onTagGbSafeParam == null) break block5;
                HandlerTagGbSafeParam handlerTagGbSafeParam = this.onTagGbSafeParam;
                synchronized (handlerTagGbSafeParam) {
                    this.onTagGbSafeParam.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagAccessLogEvent(LogBaseAccessInfo msg) {
        block5: {
            try {
                if (this.onAccessLog == null) break block5;
                HandlerTagAccessLog handlerTagAccessLog = this.onAccessLog;
                synchronized (handlerTagAccessLog) {
                    this.onAccessLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerGpiStart(LogAppGpiStart msg) {
        block7: {
            try {
                if (this.onGpiStart == null) break block7;
                HandlerGpiStart handlerGpiStart = this.onGpiStart;
                synchronized (handlerGpiStart) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onGpiStart.log(this.name, msg);
                    if (this.debugLog != null) {
                        this.debugLog.receiveDebugLog("start Gpi-[port=" + msg.getGpiPort() + ",level=" + msg.getGpiPortLevel() + "]");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerGpiOver(LogAppGpiOver msg) {
        block7: {
            try {
                if (this.onGpiOver == null) break block7;
                HandlerGpiOver handlerGpiOver = this.onGpiOver;
                synchronized (handlerGpiOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onGpiOver.log(this.name, msg);
                    if (this.debugLog != null) {
                        this.debugLog.receiveDebugLog("over Gpi-[port=" + msg.getGpiPort() + ",level=" + msg.getGpiPortLevel() + "]");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerAllGpiState(LogAppAllGpiState msg) {
        block6: {
            try {
                if (this.onAllGpiState == null) break block6;
                HandlerAllGpiState handlerAllGpiState = this.onAllGpiState;
                synchronized (handlerAllGpiState) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onAllGpiState.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerCacheDataOver(MsgAppGetCacheTagData msg) {
        block5: {
            try {
                if (this.cacheDataOver == null) break block5;
                HandlerCacheDataOver handlerCacheDataOver = this.cacheDataOver;
                synchronized (handlerCacheDataOver) {
                    this.cacheDataOver.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerDisconnected() {
        block5: {
            try {
                if (this.onDisconnected == null) break block5;
                HandlerTcpDisconnected handlerTcpDisconnected = this.onDisconnected;
                synchronized (handlerTcpDisconnected) {
                    this.onDisconnected.log(this.name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerHDKeyEvent(byte[] data) {
        block6: {
            try {
                if (this.onKeyEvent == null) break block6;
                HandlerOnKeyEvent handlerOnKeyEvent = this.onKeyEvent;
                synchronized (handlerOnKeyEvent) {
                    if (data != null && data.length == 2) {
                        BitBuffer wrap = BitBuffer.wrap(data);
                        this.onKeyEvent.event(wrap.getIntUnsigned(8), wrap.getIntUnsigned(8));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerLightingOver() {
        block5: {
            try {
                if (this.onLightingOver == null) break block5;
                HandlerLightingOver handlerLightingOver = this.onLightingOver;
                synchronized (handlerLightingOver) {
                    this.onLightingOver.log(this.name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagAntStandingWaveEvent(byte[] bytes) {
        block6: {
            try {
                if (this.onAntStandingWaveLog == null) break block6;
                HandlerAntStandingWaveLog handlerAntStandingWaveLog = this.onAntStandingWaveLog;
                synchronized (handlerAntStandingWaveLog) {
                    if (bytes != null && bytes.length >= 2) {
                        this.onAntStandingWaveLog.log(this.name, bytes[0], bytes[1]);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerSXEvent(byte[] data) {
        block5: {
            try {
                if (this.onTriggerSXEvent == null) break block5;
                HandlerOnTriggerSXEvent handlerOnTriggerSXEvent = this.onTriggerSXEvent;
                synchronized (handlerOnTriggerSXEvent) {
                    this.onTriggerSXEvent.event(data[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean open(String readerName, CommunicationInterface client, int timeout) {
        if (null == client) {
            return false;
        }
        this.ci = client;
        this.ci.onMessageReceived = new HandlerMessageReceived(){

            @Override
            public void received(Message msg) {
                GClient.this.processMessage(msg);
            }

            @Override
            public void crcLog(String hexData) {
                if (GClient.this.debugLog != null) {
                    GClient.this.debugLog.crcErrorLog(hexData);
                }
            }
        };
        this.ci.onDisconnected = new HandlerDisconnected(){

            @Override
            public void log() {
                GClient.this.triggerDisconnected();
            }
        };
        if (this.ci.isConnected()) {
            this.name = readerName;
            this.ci.setConnectType(3);
            return true;
        }
        return false;
    }

    public boolean openAndroidSerial(String readerName, int timeout) {
        try {
            this.ci = new AndroidSerialClient();
            this.ci.serialBlock = this.serialBlock;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openCusAndroidSerial(String readerName, int packageSize, int freeWait) {
        try {
            this.ci = new AndroidSerialCusClient(packageSize, freeWait);
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openCusAndroidRs485(String readerName, int packageSize, int freeWait) {
        try {
            String[] param = readerName.split(":");
            if (null == param || param.length != 3) {
                return false;
            }
            this.ci = new AndroidSerialCusClient(packageSize, freeWait);
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            if (this.ci.open(param[0] + ":" + param[1])) {
                this.name = readerName;
                this.ci.setConnectType(1);
                this.ci.setRs485(true);
                this.ci.setRs485Address(Integer.parseInt(param[2]));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openAndroidRs485(String readerName, int timeout) {
        try {
            String[] param = readerName.split(":");
            if (null == param || param.length != 3) {
                return false;
            }
            this.ci = new AndroidSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            if (this.ci.open(param[0] + ":" + param[1])) {
                this.name = readerName;
                this.ci.setConnectType(1);
                this.ci.setRs485(true);
                this.ci.setRs485Address(Integer.parseInt(param[2]));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openHdSerial(String readerName, int timeout) {
        try {
            this.ci = new AndroidPdaSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void hdPowerOn() {
        if (this.ci != null && this.ci instanceof AndroidPdaSerialClient) {
            this.ci.hdPowerOn();
        }
    }

    public void hdPowerOff() {
        if (this.ci != null && this.ci instanceof AndroidPdaSerialClient) {
            this.ci.hdPowerOff();
        }
    }

    public boolean openTcp(String readerName, int timeout) {
        try {
            this.ci = new TcpClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerDisconnected();
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(2);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openAndroidUsbSerial(AndroidUsbSerialClient usbClient) {
        try {
            this.ci = usbClient;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.name = usbClient.getUsbName();
            this.ci.setConnectType(4);
            this.ci.open("");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean openAndroidUsbRs485(AndroidUsbSerialClient usbClient, int address) {
        try {
            this.ci = usbClient;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.name = usbClient.getUsbName();
            this.ci.setRs485(true);
            this.ci.setRs485Address(address);
            this.ci.setConnectType(1);
            this.ci.open("");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean openBluetooth(String address, int timeout, int way, BluetoothClient bluetoothClient) {
        try {
            this.ci = bluetoothClient;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerDisconnected();
                }
            };
            if (this.ci.open(address, way)) {
                this.name = address;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openCwSerial(String readerName, int timeout, CWSerialClient cwSerialClient) {
        try {
            this.ci = cwSerialClient;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openBleBluetooth(String address, int auto, BleBluetoothClient bleClient) {
        try {
            this.ci = bleClient;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerDisconnected();
                }
            };
            if (this.ci.open(address, auto)) {
                this.name = address;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void openBleDevice(BleDevice bleDevice) {
        this.ci = bleDevice;
        this.ci.onMessageReceived = new HandlerMessageReceived(){

            @Override
            public void received(Message msg) {
                GClient.this.processMessage(msg);
            }

            @Override
            public void crcLog(String hexData) {
                if (GClient.this.debugLog != null) {
                    GClient.this.debugLog.crcErrorLog(hexData);
                }
            }
        };
        this.ci.open();
        if (bleDevice.getmPeripheral() != null) {
            this.name = bleDevice.getmPeripheral().getName();
        }
    }

    public void autoOpenBleDevice(BleDevice bleDevice) {
        this.ci = bleDevice;
        this.ci.onMessageReceived = new HandlerMessageReceived(){

            @Override
            public void received(Message msg) {
                GClient.this.processMessage(msg);
            }

            @Override
            public void crcLog(String hexData) {
                if (GClient.this.debugLog != null) {
                    GClient.this.debugLog.crcErrorLog(hexData);
                }
            }
        };
        this.ci.autoBleOpen();
        if (bleDevice.getmPeripheral() != null) {
            this.name = bleDevice.getmPeripheral().getName();
        }
    }

    public boolean openAndroidUsbHid(AndroidUsbHidClient hidClient) {
        try {
            this.ci = hidClient;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.name = hidClient.getUsbName();
            this.ci.setConnectType(4);
            this.ci.open("");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean createAndroidSerial(String initParam, String readerName, int timeout) {
        try {
            this.ci = new AndroidSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createAndroidRs485(String initParam, String readerName, int timeout) {
        try {
            String[] param = readerName.split(":");
            if (null == param || param.length != 3) {
                return false;
            }
            this.ci = new AndroidSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            if (this.ci.open(param[0] + ":" + param[1])) {
                this.name = readerName;
                this.ci.setConnectType(1);
                this.ci.setRs485(true);
                this.ci.setRs485Address(Integer.parseInt(param[2]));
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createTcp(String initParam, String readerName, int timeout) {
        try {
            this.ci = new TcpClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerDisconnected();
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(2);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createAndroidUsbSerial(String initParam, AndroidUsbSerialClient usbClient) {
        try {
            this.ci = usbClient;
            this.initParam = initParam;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.name = usbClient.getUsbName();
            this.ci.setConnectType(4);
            this.ci.open(initParam);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean createAndroidUsbRs485(String initParam, AndroidUsbSerialClient usbClient, int address) {
        try {
            this.ci = usbClient;
            this.initParam = initParam;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.name = usbClient.getUsbName();
            this.ci.setRs485(true);
            this.ci.setRs485Address(address);
            this.ci.setConnectType(1);
            this.ci.open(initParam);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean createBluetooth(String initParam, String address, int timeout, int way, BluetoothClient bluetoothClient) {
        try {
            this.ci = bluetoothClient;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerDisconnected();
                }
            };
            if (this.ci.open(address, way)) {
                this.name = address;
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createCwSerial(String initParam, String readerName, int timeout, CWSerialClient cwSerialClient) {
        try {
            this.ci = cwSerialClient;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createBleBluetooth(String initParam, String address, int auto, BleBluetoothClient bleClient) {
        try {
            this.ci = bleClient;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerDisconnected();
                }
            };
            if (this.ci.open(address, auto)) {
                this.name = address;
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void createBleDevice(String initParam, BleDevice bleDevice) {
        this.ci = bleDevice;
        this.initParam = initParam;
        this.ci.onMessageReceived = new HandlerMessageReceived(){

            @Override
            public void received(Message msg) {
                GClient.this.processMessage(msg);
            }

            @Override
            public void crcLog(String hexData) {
                if (GClient.this.debugLog != null) {
                    GClient.this.debugLog.crcErrorLog(hexData);
                }
            }
        };
        this.ci.open(initParam);
        if (bleDevice.getmPeripheral() != null) {
            this.name = bleDevice.getmPeripheral().getName();
        }
    }

    public boolean createAndroidUsbHid(String initParam, AndroidUsbHidClient hidClient) {
        try {
            this.ci = hidClient;
            this.initParam = initParam;
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }

                @Override
                public void crcLog(String hexData) {
                    if (GClient.this.debugLog != null) {
                        GClient.this.debugLog.crcErrorLog(hexData);
                    }
                }
            };
            this.name = hidClient.getUsbName();
            this.ci.setConnectType(4);
            this.ci.open(initParam);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean close() {
        try {
            if (null != this.ci) {
                this.ci.close();
                this.ci.onMessageReceived = null;
                this.ci.onDisconnected = null;
                this.ci = null;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void sendSynMsg(Message msg, int timeout) {
        if (this.ci == null) {
            return;
        }
        if (null == msg) {
            return;
        }
        if (this.getConnectType() == 1) {
            msg.msgType.mt_13 = "1";
        }
        int mreKey = msg.msgType.toInt();
        if (null == this.dicMre) {
            this.dicMre = new HashMap();
        }
        if (!this.dicMre.containsKey(mreKey)) {
            ClientManualResetEvent cmre = new ClientManualResetEvent(false);
            cmre.data = null;
            this.dicMre.put(mreKey, cmre);
        } else {
            this.dicMre.get((Object)Integer.valueOf((int)mreKey)).data = null;
            this.dicMre.get((Object)Integer.valueOf((int)mreKey)).evt.reset();
        }
        try {
            this.ci.send(msg);
            if (this.isPrint && this.debugLog != null) {
                this.debugLog.sendDebugLog("send-[" + msg.getClass().getSimpleName() + "]-[" + HexUtils.bytes2HexString(msg.msgData) + "]");
            }
            this.dicMre.get((Object)Integer.valueOf((int)mreKey)).evt.waitOne(timeout);
            if (null != this.dicMre.get((Object)Integer.valueOf((int)mreKey)).data) {
                msg.msgData = this.dicMre.get((Object)Integer.valueOf((int)mreKey)).data.msgData;
                msg.ackUnpack(this.dicMre.get((Object)Integer.valueOf((int)mreKey)).data.cData);
                if (this.isPrint && this.debugLog != null) {
                    this.debugLog.receiveDebugLog("receive-[" + msg.getClass().getSimpleName() + "]-[" + HexUtils.bytes2HexString(msg.msgData) + "]");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendSynMsg(Message msg) {
        this.sendSynMsg(msg, 3000);
    }

    public void sendSynMsgRetry(Message msg, int timeout, int retry) {
        for (int i = 0; i < retry; ++i) {
            this.sendSynMsg(msg, timeout);
            if (0 == msg.getRtCode()) break;
        }
    }

    public void sendUnsynMsg(Message msg) {
        if (this.ci == null) {
            return;
        }
        if (null == msg) {
            return;
        }
        this.ci.send(msg);
        if (this.isPrint && this.debugLog != null) {
            this.debugLog.sendDebugLog("send-[" + msg.getClass().getSimpleName() + "]-[" + HexUtils.bytes2HexString(msg.msgData) + "]");
        }
    }

    public void sendUnsynMsg(byte[] msg) {
        if (this.ci == null) {
            return;
        }
        if (null == msg) {
            return;
        }
        this.ci.send(msg);
        if (this.isPrint && this.debugLog != null) {
            this.debugLog.sendDebugLog("send-[custom]-[" + HexUtils.bytes2HexString(msg) + "]");
        }
    }

    public void sendUnsynMsgRetry(Message msg, int retry) {
        for (int i = 0; i < retry; ++i) {
            this.sendUnsynMsg(msg);
        }
    }

    private void processMessage(Message msg) {
        try {
            if (null == msg) {
                return;
            }
            if (msg.msgType.mt_12.equals("0")) {
                ClientManualResetEvent event;
                int mreKey = msg.msgType.toInt();
                if (this.dicMre.containsKey(mreKey) && (event = this.dicMre.get(mreKey)) != null) {
                    event.data = msg;
                    event.evt.set();
                }
            } else if (msg.msgType.mt_8_11.equals("0010")) {
                if (0 == msg.msgType.msgId) {
                    LogBaseEpcInfo log = new LogBaseEpcInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTagEpcLogEvent(log);
                } else if (32 == msg.msgType.msgId) {
                    LogBase6bInfo log = new LogBase6bInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTag6bLogEvent(log);
                } else if (48 == msg.msgType.msgId) {
                    LogBaseGbInfo log = new LogBaseGbInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGbLogEvent(log);
                } else if (64 == msg.msgType.msgId) {
                    LogBaseGJbInfo log = new LogBaseGJbInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGJbLogEvent(log);
                } else if (1 == msg.msgType.msgId) {
                    LogBaseEpcOver log = new LogBaseEpcOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTagEpcOverEvent(log);
                } else if (33 == msg.msgType.msgId) {
                    LogBase6bOver log = new LogBase6bOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTag6bOverEvent(log);
                } else if (49 == msg.msgType.msgId) {
                    LogBaseGbOver log = new LogBaseGbOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGbOverEvent(log);
                } else if (65 == msg.msgType.msgId) {
                    LogBaseGJbOver log = new LogBaseGJbOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGJbOverEvent(log);
                } else if (50 == msg.msgType.msgId) {
                    LogBaseGbSafeParam log = new LogBaseGbSafeParam();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGbSafeParamEvent(log);
                } else if (67 == msg.msgType.msgId) {
                    this.triggerTagGJbRn11LogEvent(msg.cData);
                } else if (80 == msg.msgType.msgId) {
                    LogBaseTLInfo log = new LogBaseTLInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTagTLLogEvent(log);
                } else if (81 == msg.msgType.msgId) {
                    LogBaseTLOver log = new LogBaseTLOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTagTLOverEvent(log);
                } else if (85 == msg.msgType.msgId) {
                    LogBase6DInfo log = new LogBase6DInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTag6DLogEvent(log);
                } else if (86 == msg.msgType.msgId) {
                    LogBase6DOver log = new LogBase6DOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTag6DOverEvent(log);
                } else if (2 == msg.msgType.msgId) {
                    this.triggerTagAntIdEvent(msg.cData[0]);
                } else if (-128 == msg.msgType.msgId) {
                    LogBaseAccessInfo log = new LogBaseAccessInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTagAccessLogEvent(log);
                } else if (6 == msg.msgType.msgId) {
                    this.triggerLightingOver();
                } else if (3 == msg.msgType.msgId) {
                    this.triggerTagAntStandingWaveEvent(msg.cData);
                }
            } else if (msg.msgType.mt_8_11.equals("0001")) {
                Message log;
                if (18 == msg.msgType.msgId) {
                    if (this.isPrint) {
                        GLog.d("[heartbeat]");
                    }
                    MsgAppHeartbeat msgAppHeartbeat = new MsgAppHeartbeat();
                    msgAppHeartbeat.msgType = msg.msgType;
                    msgAppHeartbeat.ackUnpack(msg.cData);
                    this.sendUnsynMsg(msgAppHeartbeat);
                    if (this.onHeartbeatLog != null) {
                        this.onHeartbeatLog.log(this.name);
                    }
                }
                if (0 == msg.msgType.msgId) {
                    log = new LogAppGpiStart();
                    log.ackUnpack(msg.cData);
                    this.triggerGpiStart((LogAppGpiStart)log);
                } else if (1 == msg.msgType.msgId) {
                    log = new LogAppGpiOver();
                    log.ackUnpack(msg.cData);
                    this.triggerGpiOver((LogAppGpiOver)log);
                } else if (2 == msg.msgType.msgId) {
                    log = new LogAppAllGpiState();
                    log.ackUnpack(msg.cData);
                    this.triggerAllGpiState((LogAppAllGpiState)log);
                } else if (27 == msg.msgType.msgId) {
                    MsgAppGetCacheTagData cacheTagData = new MsgAppGetCacheTagData();
                    cacheTagData.ackUnpack(msg.cData);
                    this.triggerCacheDataOver(cacheTagData);
                }
            } else if (msg.msgType.mt_8_11.equals("0101")) {
                if (2 == msg.msgType.msgId) {
                    this.sendUnsynMsg(new MsgTestWorkModeInit(this.initParam, 0));
                }
            } else if (msg.msgType.mt_8_11.equals("1111")) {
                if (0 == msg.msgType.msgId) {
                    this.triggerHDKeyEvent(msg.cData);
                } else if (1 == msg.msgType.msgId) {
                    this.triggerSXEvent(msg.cData);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

