/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.GLog;
import com.gg.reader.api.utils.ThreadPoolUtils;
import com.gxwl.device.reader.dal.SerialPortJNI;
import java.net.Socket;

public class AndroidSerialCusClient
extends CommunicationInterface {
    private int packageSize = 64;
    private int freeWait = 1;

    public AndroidSerialCusClient(int packageSize, int freeWait) {
        this.packageSize = packageSize;
        this.freeWait = freeWait;
    }

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        return false;
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    @Override
    public boolean open(String param) {
        try {
            String[] arrParam = param.split(":");
            if (arrParam.length == 2) {
                if (1 == SerialPortJNI.openPort(arrParam[0], Integer.parseInt(arrParam[1]), 8, 1, 'N')) {
                    this.keepReceived = true;
                    this.startReceive();
                    this.startProcess();
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (AndroidSerialCusClient.this.keepReceived) {
                    try {
                        byte[] bytes = SerialPortJNI.readPort(AndroidSerialCusClient.this.packageSize);
                        if (bytes != null && bytes.length > 0) {
                            Object object = AndroidSerialCusClient.this.lockRingBuffer;
                            synchronized (object) {
                                while (bytes.length + AndroidSerialCusClient.this.ringBuffer.getDataCount() > 0x100000) {
                                    AndroidSerialCusClient.this.lockRingBuffer.wait(10000L);
                                }
                                AndroidSerialCusClient.this.ringBuffer.WriteBuffer(bytes, 0, bytes.length);
                                AndroidSerialCusClient.this.lockRingBuffer.notify();
                                continue;
                            }
                        }
                        Thread.sleep(AndroidSerialCusClient.this.freeWait);
                    }
                    catch (Exception ex) {
                        GLog.e("[AndroidSerialCusClient]startReceive error." + ex.getMessage());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.keepReceived = false;
            SerialPortJNI.closePort();
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) {
        Class<AndroidSerialCusClient> clazz = AndroidSerialCusClient.class;
        synchronized (AndroidSerialCusClient.class) {
            try {
                SerialPortJNI.writePort(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message msg) {
        Class<AndroidSerialCusClient> clazz = AndroidSerialCusClient.class;
        synchronized (AndroidSerialCusClient.class) {
            try {
                if (this.isRs485) {
                    msg.msgType.mt_13 = "1";
                    msg.rs485Address = this.getRs485Address();
                }
                msg.pack();
                byte[] sendData = msg.toBytes(this.isRs485);
                this.send(sendData);
            }
            catch (Exception ex) {
                GLog.e("[AndroidSerialCusClient]base serial send error:" + ex.getMessage());
            }
            return;
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
    }
}

