/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.gg.reader.api.dal.communication.BleClientCallback;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@RequiresApi(api=18)
public class BleBluetoothClient
extends CommunicationInterface {
    private final String TAG = BleBluetoothClient.class.getName();
    private BluetoothManager manager;
    private BluetoothDevice device;
    private Context context;
    private BluetoothGattCharacteristic mWriteCharacteristic;
    private BluetoothGattCharacteristic mNotifyCharacteristic;
    private UUID SERVER_UUID = UUID.fromString("0000fff0-0000-1000-8000-00805F9B34FB");
    private UUID NOTIFY_UUID = UUID.fromString("0000fff1-0000-1000-8000-00805F9B34FB");
    private UUID WRITE_UUID = UUID.fromString("0000fff2-0000-1000-8000-00805F9B34FB");
    private static final UUID DESCRIPTOR = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private BluetoothAdapter adapter;
    private BluetoothGatt bluetoothGatt;
    private Map<String, BluetoothDevice> deviceMap = new HashMap<String, BluetoothDevice>();
    private Handler scanHandler = new Handler();
    public BleClientCallback.OnBlueConnectCallBack connectCallBack;
    public BleClientCallback.OnBlueScanCallBack scanCallBack;
    private long writeTime = 50L;
    private int mtu = 512;
    private boolean isPackage = false;
    BluetoothAdapter.LeScanCallback leScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            BleBluetoothClient.this.deviceMap.put(device.getAddress(), device);
            BleBluetoothClient.this.scanCallBack.onBlueFind(device);
        }
    };
    private final Runnable mScanRunnable = new Runnable(){

        @Override
        public void run() {
            BleBluetoothClient.this.scanBluetooth(false, 5000L);
        }
    };
    BluetoothGattCallback mBluetoothGattCallback = new BluetoothGattCallback(){

        @RequiresApi(api=21)
        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (newState == 2) {
                Log.e((String)BleBluetoothClient.this.TAG, (String)"STATE_CONNECTED");
                BleBluetoothClient.this.bluetoothGatt.discoverServices();
                boolean b = BleBluetoothClient.this.requestMtu(gatt);
                Log.e((String)"requestMtu-->", (String)(b + ""));
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else if (newState == 0) {
                Log.e((String)BleBluetoothClient.this.TAG, (String)"STATE_DISCONNECTED");
                BleBluetoothClient.this.connectCallBack.onDisconnect();
            } else if (newState == 3) {
                Log.e((String)BleBluetoothClient.this.TAG, (String)"STATE_DISCONNECTING");
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                BleBluetoothClient.this.connectCallBack.onConnectSuccess();
                BleBluetoothClient.this.enableTxNotification();
            } else {
                BleBluetoothClient.this.connectCallBack.onConnectFailure();
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0 && characteristic.getValue().length > 0) {
                Log.e((String)BleBluetoothClient.this.TAG, (String)("onCharacteristicRead" + Arrays.toString(characteristic.getValue())));
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0 && characteristic.getValue().length > 0) {
                Log.e((String)BleBluetoothClient.this.TAG, (String)("onCharacteristicWrite" + Arrays.toString(characteristic.getValue())));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            if (characteristic.getValue().length <= 0) {
                Log.e((String)BleBluetoothClient.this.TAG, (String)"receive data is null");
                return;
            }
            Log.e((String)("ble receive--->" + Thread.currentThread().getName()), (String)HexUtils.bytes2HexString(characteristic.getValue()));
            try {
                byte[] data = characteristic.getValue();
                Object object = BleBluetoothClient.this.lockRingBuffer;
                synchronized (object) {
                    while (data.length + BleBluetoothClient.this.ringBuffer.getDataCount() > 0x100000) {
                        BleBluetoothClient.this.lockRingBuffer.wait(10000L);
                    }
                    BleBluetoothClient.this.ringBuffer.WriteBuffer(data, 0, data.length);
                    BleBluetoothClient.this.lockRingBuffer.notify();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorRead(gatt, descriptor, status);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorWrite(gatt, descriptor, status);
        }
    };

    public BleBluetoothClient(Context context) {
        this.context = context;
        this.manager = (BluetoothManager)this.context.getSystemService("bluetooth");
        this.adapter = this.manager.getAdapter();
    }

    public void setWriteTime(long writeTime) {
        this.writeTime = writeTime;
    }

    public boolean isSupportBle(Context context) {
        if (context == null || !context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return false;
        }
        return this.adapter != null;
    }

    public boolean isBleEnable(Context context) {
        if (!this.isSupportBle(context)) {
            return false;
        }
        return this.adapter.isEnabled();
    }

    public BluetoothAdapter getAdapter() {
        return this.adapter;
    }

    public UUID getSERVER_UUID() {
        return this.SERVER_UUID;
    }

    public void setSERVER_UUID(UUID SERVER_UUID) {
        this.SERVER_UUID = SERVER_UUID;
    }

    public UUID getNOTIFY_UUID() {
        return this.NOTIFY_UUID;
    }

    public void setNOTIFY_UUID(UUID NOTIFY_UUID) {
        this.NOTIFY_UUID = NOTIFY_UUID;
    }

    public UUID getWRITE_UUID() {
        return this.WRITE_UUID;
    }

    public void setWRITE_UUID(UUID WRITE_UUID) {
        this.WRITE_UUID = WRITE_UUID;
    }

    public void enableBluetooth() {
        this.adapter.enable();
    }

    public BluetoothGatt getBluetoothGatt() {
        return this.bluetoothGatt;
    }

    public void openBluetoothSetting() {
        Intent intent = new Intent();
        intent.setAction("android.settings.BLUETOOTH_SETTINGS");
        intent.setFlags(0x10000000);
        this.context.startActivity(intent);
    }

    public void scanBluetooth(boolean enable, long scanTime) {
        if (enable) {
            if (this.adapter.isEnabled()) {
                this.scanHandler.postDelayed(this.mScanRunnable, scanTime);
                this.adapter.startLeScan(this.leScanCallback);
            }
        } else {
            this.adapter.stopLeScan(this.leScanCallback);
            this.scanHandler.removeCallbacks(this.mScanRunnable);
        }
    }

    public void stopScanBluetooth() {
        this.adapter.stopLeScan(this.leScanCallback);
    }

    public void enableTxNotification() {
        BluetoothGattService service = this.bluetoothGatt.getService(this.SERVER_UUID);
        this.mWriteCharacteristic = service.getCharacteristic(this.WRITE_UUID);
        this.mNotifyCharacteristic = service.getCharacteristic(this.NOTIFY_UUID);
        this.bluetoothGatt.setCharacteristicNotification(this.mNotifyCharacteristic, true);
        BluetoothGattDescriptor mDescriptor = this.mNotifyCharacteristic.getDescriptor(DESCRIPTOR);
        if (mDescriptor != null) {
            if ((this.mNotifyCharacteristic.getProperties() & 0x10) > 0) {
                mDescriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            } else if ((this.mNotifyCharacteristic.getProperties() & 0x20) > 0) {
                mDescriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
            }
        }
        this.bluetoothGatt.writeDescriptor(mDescriptor);
    }

    @Override
    public boolean open(String s, int i) {
        if (StringUtils.isNullOfEmpty(s)) {
            return false;
        }
        if (this.adapter.isDiscovering()) {
            this.adapter.cancelDiscovery();
        }
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
            this.bluetoothGatt.discoverServices();
        }
        this.device = this.deviceMap.containsKey(s) ? this.deviceMap.get(s) : this.adapter.getRemoteDevice(s);
        if (this.device != null) {
            this.bluetoothGatt = Build.VERSION.SDK_INT >= 26 ? this.device.connectGatt(this.context, false, this.mBluetoothGattCallback, 2, 1) : (Build.VERSION.SDK_INT >= 23 ? this.device.connectGatt(this.context, false, this.mBluetoothGattCallback, 2) : this.device.connectGatt(this.context, false, this.mBluetoothGattCallback));
            this.keepReceived = true;
            this.startProcess();
            return true;
        }
        return false;
    }

    @Override
    public boolean open(Socket socket) {
        return false;
    }

    @Override
    public boolean open(String s, int i, int i1) {
        return false;
    }

    @Override
    public boolean open(String s) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.keepReceived = false;
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
            this.bluetoothGatt.close();
            this.mWriteCharacteristic = null;
            this.mNotifyCharacteristic = null;
            this.bluetoothGatt = null;
        }
        this.device = null;
        Object object = this.lockRingBuffer;
        synchronized (object) {
            this.lockRingBuffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) {
        Class<BleBluetoothClient> clazz = BleBluetoothClient.class;
        synchronized (BleBluetoothClient.class) {
            try {
                if (this.mWriteCharacteristic != null) {
                    if (this.isPackage) {
                        int size = data.length / 20;
                        if (data.length % 20 != 0) {
                            ++size;
                        }
                        for (int i = 0; i < size; ++i) {
                            byte[] newBuffer = Arrays.copyOfRange(data, i * 20, 20 + i * 20);
                            this.mWriteCharacteristic.setValue(newBuffer);
                            this.bluetoothGatt.writeCharacteristic(this.mWriteCharacteristic);
                            Thread.sleep(this.writeTime);
                        }
                    } else {
                        this.mWriteCharacteristic.setValue(data);
                        this.bluetoothGatt.writeCharacteristic(this.mWriteCharacteristic);
                        Thread.sleep(this.writeTime);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message message) {
        Class<BleBluetoothClient> clazz = BleBluetoothClient.class;
        synchronized (BleBluetoothClient.class) {
            try {
                message.pack();
                this.send(message.toBytes(this.isRs485));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
    }

    @Override
    public int receive(byte[] bytes) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int i) {
        return false;
    }

    @Override
    public void dispose() {
    }

    @RequiresApi(api=21)
    private boolean requestMtu(BluetoothGatt gatt) {
        if (gatt != null) {
            return gatt.requestMtu(this.mtu);
        }
        return false;
    }

    public void setMtu(int value) {
        this.mtu = value;
    }

    public void setPartPackage(boolean isValue) {
        this.isPackage = isValue;
    }
}

