/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.ParamEpcFilter;
import com.gg.reader.api.protocol.gx.ParamEpcReadTid;
import com.gg.reader.api.protocol.gx.ParamGbReadUserdata;
import com.gg.reader.api.protocol.gx.Parameter;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;

public class HybridGbParam
extends Parameter {
    private ParamEpcFilter filter;
    private ParamEpcReadTid readTid;
    private ParamGbReadUserdata readUserdata;
    private String hexPassword;

    public ParamEpcFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ParamEpcFilter filter) {
        this.filter = filter;
    }

    public ParamEpcReadTid getReadTid() {
        return this.readTid;
    }

    public void setReadTid(ParamEpcReadTid readTid) {
        this.readTid = readTid;
    }

    public ParamGbReadUserdata getReadUserdata() {
        return this.readUserdata;
    }

    public void setReadUserdata(ParamGbReadUserdata readUserdata) {
        this.readUserdata = readUserdata;
    }

    public String getHexPassword() {
        return this.hexPassword;
    }

    public void setHexPassword(String hexPassword) {
        this.hexPassword = hexPassword;
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes;
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (null != this.filter) {
            buffer.putInt(1, 8);
            bytes = this.filter.toBytes();
            buffer.putInt(bytes.length, 16);
            buffer.put(bytes);
        }
        if (null != this.readTid) {
            buffer.putInt(2, 8);
            bytes = this.readTid.toBytes();
            buffer.put(bytes);
        }
        if (null != this.readUserdata) {
            buffer.putInt(3, 8);
            bytes = this.readUserdata.toBytes();
            buffer.put(bytes);
        }
        if (!StringUtils.isNullOfEmpty(this.hexPassword)) {
            buffer.putInt(5, 8);
            bytes = HexUtils.hexString2Bytes(this.hexPassword);
            buffer.put(bytes);
        }
        return buffer.asByteArray();
    }
}

