/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class LogAppAllGpiState
extends Message {
    private int gpiPortLevel;
    private String readerSerialNumber;

    public LogAppAllGpiState() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)2;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getGpiPortLevel() {
        return this.gpiPortLevel;
    }

    public void setGpiPortLevel(int gpiPortLevel) {
        this.gpiPortLevel = gpiPortLevel;
    }

    public String getReaderSerialNumber() {
        return this.readerSerialNumber;
    }

    public void setReaderSerialNumber(String readerSerialNumber) {
        this.readerSerialNumber = readerSerialNumber;
    }

    @Override
    public void pack() {
        super.pack();
    }

    @Override
    public void ackPack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.gpiPortLevel, 32);
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.gpiPortLevel = buffer.getIntUnsigned(32);
        }
    }

    public String toBinaryString(int value, int bitLen) {
        int item = 1 << bitLen | value;
        String arr = Integer.toBinaryString(item);
        return arr.substring(1);
    }

    public String toBinaryString(int bitLen) {
        int item = 1 << (bitLen == 32 ? 31 : bitLen) | this.gpiPortLevel;
        String arr = Integer.toBinaryString(item).substring(1);
        return bitLen == 32 ? "0" + arr : arr;
    }
}

