/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;

public class LogAppGpiStart
extends Message {
    private int gpiPort;
    private int gpiPortLevel;
    private Date systemTime = new Date();
    private String readerSerialNumber;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public LogAppGpiStart() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = 0;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getGpiPort() {
        return this.gpiPort;
    }

    public void setGpiPort(int gpiPort) {
        this.gpiPort = gpiPort;
    }

    public int getGpiPortLevel() {
        return this.gpiPortLevel;
    }

    public void setGpiPortLevel(int gpiPortLevel) {
        this.gpiPortLevel = gpiPortLevel;
    }

    public Date getSystemTime() {
        return this.systemTime;
    }

    public void setSystemTime(Date systemTime) {
        this.systemTime = systemTime;
    }

    public String getReaderSerialNumber() {
        return this.readerSerialNumber;
    }

    public void setReaderSerialNumber(String readerSerialNumber) {
        this.readerSerialNumber = readerSerialNumber;
    }

    @Override
    public void pack() {
        super.pack();
    }

    @Override
    public void ackPack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.gpiPort, 8);
        buffer.putLong(this.gpiPortLevel, 8);
        String utc = new Formatter().format("%.3f", (double)DateTimeUtils.UtcFromTimeZone(this.systemTime, TimeZone.getDefault()) / 1000.0).toString();
        String[] split = utc.split("\\.");
        buffer.putLong(Integer.parseInt(split[0]), 32);
        buffer.putLong(Integer.parseInt(split[1]) * 1000, 32);
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.gpiPort = buffer.getIntUnsigned(8);
            this.gpiPortLevel = buffer.getIntUnsigned(8);
            long utcSecond = buffer.getLong(32) * 1000L;
            long utcMicrosecond = buffer.getLong(32) / 1000L;
            long ms = utcSecond + utcMicrosecond;
            this.systemTime = DateTimeUtils.fromUtcToTimeZone(ms, TimeZone.getDefault());
        }
    }

    public String toString() {
        return "LogAppGpiStart{gpiPort=" + this.gpiPort + ", gpiPortLevel=" + this.gpiPortLevel + ", systemTime=" + this.format.format(this.systemTime) + ", readerSerialNumber='" + this.readerSerialNumber + '\'' + '}';
    }
}

