/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.StringUtils;
import java.io.UnsupportedEncodingException;

public class MsgAppGetHttpParam
extends Message {
    private int onOrOff;
    private int period = 0;
    private int format = 0;
    private int timeout = 0;
    private int openCache = 0;
    private String reportAddress;

    public MsgAppGetHttpParam() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)42;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetHttpParam(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.onOrOff = buffer.getIntUnsigned(8);
            this.period = buffer.getIntUnsigned(16);
            this.format = buffer.getIntUnsigned(8);
            this.timeout = buffer.getIntUnsigned(16);
            this.openCache = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        int reLen = buffer.getIntUnsigned(16);
                        if (reLen <= 0) break;
                        this.reportAddress = new String(buffer.get(new byte[reLen]), "ASCII");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getOnOrOff() {
        return this.onOrOff;
    }

    public void setOnOrOff(int onOrOff) {
        this.onOrOff = onOrOff;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getOpenCache() {
        return this.openCache;
    }

    public void setOpenCache(int openCache) {
        this.openCache = openCache;
    }

    public String getReportAddress() {
        return this.reportAddress;
    }

    public void setReportAddress(String reportAddress) {
        this.reportAddress = reportAddress;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putInt(this.onOrOff, 8);
            buffer.putInt(this.period, 16);
            buffer.put(this.format, 8);
            buffer.put(this.timeout, 16);
            buffer.putInt(this.openCache, 8);
            if (!StringUtils.isNullOfEmpty(this.reportAddress)) {
                buffer.putInt(this.reportAddress.length(), 16);
                buffer.put(this.reportAddress);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.onOrOff = buffer.getIntUnsigned(8);
            this.period = buffer.getIntUnsigned(16);
            this.format = buffer.getIntUnsigned(8);
            this.timeout = buffer.getIntUnsigned(16);
            this.openCache = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < this.cData.length) {
                int pid = buffer.getIntUnsigned(8);
                switch (pid) {
                    case 1: {
                        int reLen = buffer.getIntUnsigned(16);
                        if (reLen <= 0) break;
                        try {
                            this.reportAddress = new String(buffer.get(new byte[reLen]), "ASCII");
                            break;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetHttpParam{onOrOff=" + this.onOrOff + ", period=" + this.period + ", format=" + this.format + ", timeout=" + this.timeout + ", openCache=" + this.openCache + ", reportAddress='" + this.reportAddress + '\'' + '}';
    }
}

