/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgAppSetGpiTrigger
extends Message {
    private int gpiPort;
    private int triggerStart;
    private byte[] triggerCommand;
    private String hexTriggerCommand;
    private int triggerOver;
    private int overDelayTime = Integer.MAX_VALUE;
    private int levelUploadSwitch = Integer.MAX_VALUE;
    private int antiShakeTime = Integer.MAX_VALUE;

    public MsgAppSetGpiTrigger() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)11;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppSetGpiTrigger(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.gpiPort = buffer.getIntUnsigned(8);
            this.triggerStart = buffer.getIntUnsigned(8);
            int cmdLen = buffer.getIntUnsigned(16);
            if (cmdLen > 0) {
                byte[] triggerCommandData = new byte[cmdLen];
                this.triggerCommand = buffer.get(triggerCommandData);
                this.hexTriggerCommand = HexUtils.bytes2HexString(this.triggerCommand);
            }
            this.triggerOver = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        this.overDelayTime = buffer.getIntUnsigned(16);
                        break;
                    }
                    case 2: {
                        this.levelUploadSwitch = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getGpiPort() {
        return this.gpiPort;
    }

    public void setGpiPort(int gpiPort) {
        this.gpiPort = gpiPort;
    }

    public int getTriggerStart() {
        return this.triggerStart;
    }

    public void setTriggerStart(int triggerStart) {
        this.triggerStart = triggerStart;
    }

    public byte[] getTriggerCommand() {
        return this.triggerCommand;
    }

    public void setTriggerCommand(byte[] triggerCommand) {
        this.triggerCommand = triggerCommand;
    }

    public int getTriggerOver() {
        return this.triggerOver;
    }

    public void setTriggerOver(int triggerOver) {
        this.triggerOver = triggerOver;
    }

    public int getOverDelayTime() {
        return this.overDelayTime;
    }

    public void setOverDelayTime(int overDelayTime) {
        this.overDelayTime = overDelayTime;
    }

    public int getLevelUploadSwitch() {
        return this.levelUploadSwitch;
    }

    public void setLevelUploadSwitch(int levelUploadSwitch) {
        this.levelUploadSwitch = levelUploadSwitch;
    }

    public String getHexTriggerCommand() {
        return this.hexTriggerCommand;
    }

    public void setHexTriggerCommand(String hexTriggerCommand) {
        if (!StringUtils.isNullOfEmpty(hexTriggerCommand)) {
            this.hexTriggerCommand = hexTriggerCommand;
            this.triggerCommand = HexUtils.hexString2Bytes(this.hexTriggerCommand);
        }
    }

    public int getAntiShakeTime() {
        return this.antiShakeTime;
    }

    public void setAntiShakeTime(int antiShakeTime) {
        this.antiShakeTime = antiShakeTime;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.gpiPort, 8);
        buffer.putLong(this.triggerStart, 8);
        if (null != this.triggerCommand && this.triggerCommand.length >= 0) {
            buffer.putInt(this.triggerCommand.length, 16);
            buffer.put(this.triggerCommand);
        } else {
            buffer.putInt(0, 16);
        }
        buffer.putLong(this.triggerOver, 8);
        if (Integer.MAX_VALUE != this.overDelayTime) {
            buffer.putInt(1, 8);
            buffer.put(this.overDelayTime, 16);
        }
        if (Integer.MAX_VALUE != this.levelUploadSwitch) {
            buffer.putInt(2, 8);
            buffer.putLong(this.levelUploadSwitch, 8);
        }
        if (Integer.MAX_VALUE != this.antiShakeTime) {
            buffer.putInt(3, 8);
            buffer.putInt(this.antiShakeTime, 16);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Port parameter reader hardware is not supported .");
                this.put((byte)2, "Parameters are missing .");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

