/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class MsgAppUsbKeyboard
extends Message {
    private int operationType;
    private int reportType = Integer.MAX_VALUE;
    private int encodingMethod = Integer.MAX_VALUE;
    private String prefix;
    private String suffix;
    private int sleepTime = Integer.MAX_VALUE;
    private int readyWaitTime = Integer.MAX_VALUE;

    public MsgAppUsbKeyboard() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)43;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getOperationType() {
        return this.operationType;
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
    }

    public int getEncodingMethod() {
        return this.encodingMethod;
    }

    public void setEncodingMethod(int encodingMethod) {
        this.encodingMethod = encodingMethod;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public int getReadyWaitTime() {
        return this.readyWaitTime;
    }

    public void setReadyWaitTime(int readyWaitTime) {
        this.readyWaitTime = readyWaitTime;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.operationType, 8);
        if (this.operationType == 1) {
            if (this.reportType != Integer.MAX_VALUE) {
                buffer.putInt(1, 8);
                buffer.putLong(this.reportType, 8);
            }
            if (this.encodingMethod != Integer.MAX_VALUE) {
                buffer.putInt(2, 8);
                buffer.putLong(this.encodingMethod, 8);
            }
            if (!StringUtils.isNullOfEmpty(this.prefix)) {
                buffer.putInt(3, 8);
                buffer.putInt(this.prefix.length(), 16);
                buffer.put(this.prefix);
            } else {
                buffer.putInt(3, 8);
                buffer.putInt(0, 16);
            }
            if (!StringUtils.isNullOfEmpty(this.suffix)) {
                buffer.putInt(4, 8);
                buffer.putInt(this.suffix.length(), 16);
                buffer.put(this.suffix);
            } else {
                buffer.putInt(4, 8);
                buffer.putInt(0, 16);
            }
            if (this.sleepTime != Integer.MAX_VALUE) {
                buffer.putInt(5, 8);
                buffer.putLong(this.sleepTime, 16);
            }
            if (this.readyWaitTime != Integer.MAX_VALUE) {
                buffer.putInt(6, 8);
                buffer.putLong(this.readyWaitTime, 16);
            }
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Failed.");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.setRtCode((byte)buffer.getIntUnsigned(8));
            if (dicErrorMsg.containsKey(this.getRtCode())) {
                this.setRtMsg((String)dicErrorMsg.get(this.getRtCode()));
            }
            while (buffer.position() / 8 < this.cData.length) {
                int pid = buffer.getIntUnsigned(8);
                switch (pid) {
                    case 1: {
                        this.reportType = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 2: {
                        this.encodingMethod = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 3: {
                        int preLen = buffer.getIntUnsigned(16);
                        if (preLen <= 0) break;
                        try {
                            this.prefix = new String(buffer.get(new byte[preLen]), "ASCII");
                            break;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case 4: {
                        int sufLen = buffer.getIntUnsigned(16);
                        if (sufLen <= 0) break;
                        try {
                            this.suffix = new String(buffer.get(new byte[sufLen]), "ASCII");
                            break;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    case 5: {
                        this.sleepTime = buffer.getIntUnsigned(16);
                        break;
                    }
                    case 6: {
                        this.readyWaitTime = buffer.getIntUnsigned(16);
                    }
                }
            }
        }
    }
}

