/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgBaseGetBaseband
extends Message {
    private int baseSpeed = Integer.MAX_VALUE;
    private int qValue = Integer.MAX_VALUE;
    private int session = Integer.MAX_VALUE;
    private int inventoryFlag = Integer.MAX_VALUE;
    private int Tari = Integer.MAX_VALUE;
    private int DR = Integer.MAX_VALUE;
    private int RTcal = Integer.MAX_VALUE;
    private int TRcal = Integer.MAX_VALUE;
    private int PW = Integer.MAX_VALUE;
    private int modulationDepth = Integer.MAX_VALUE;
    private int Miller = Integer.MAX_VALUE;

    public MsgBaseGetBaseband() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)12;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseGetBaseband(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.baseSpeed = buffer.getIntUnsigned(8);
            this.qValue = buffer.getIntUnsigned(8);
            this.session = buffer.getIntUnsigned(8);
            this.inventoryFlag = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBaseSpeed() {
        return this.baseSpeed;
    }

    public void setBaseSpeed(int baseSpeed) {
        this.baseSpeed = baseSpeed;
    }

    public int getqValue() {
        return this.qValue;
    }

    public void setqValue(int qValue) {
        this.qValue = qValue;
    }

    public int getSession() {
        return this.session;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public int getInventoryFlag() {
        return this.inventoryFlag;
    }

    public void setInventoryFlag(int inventoryFlag) {
        this.inventoryFlag = inventoryFlag;
    }

    public int getTari() {
        return this.Tari;
    }

    public void setTari(int tari) {
        this.Tari = tari;
    }

    public int getDR() {
        return this.DR;
    }

    public void setDR(int DR) {
        this.DR = DR;
    }

    public int getRTcal() {
        return this.RTcal;
    }

    public void setRTcal(int RTcal) {
        this.RTcal = RTcal;
    }

    public int getTRcal() {
        return this.TRcal;
    }

    public void setTRcal(int TRcal) {
        this.TRcal = TRcal;
    }

    public int getPW() {
        return this.PW;
    }

    public void setPW(int PW) {
        this.PW = PW;
    }

    public int getModulationDepth() {
        return this.modulationDepth;
    }

    public void setModulationDepth(int modulationDepth) {
        this.modulationDepth = modulationDepth;
    }

    public int getMiller() {
        return this.Miller;
    }

    public void setMiller(int miller) {
        this.Miller = miller;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (Integer.MAX_VALUE != this.baseSpeed) {
                buffer.putLong(this.baseSpeed, 8);
            }
            if (Integer.MAX_VALUE != this.qValue) {
                buffer.putLong(this.qValue, 8);
            }
            if (Integer.MAX_VALUE != this.session) {
                buffer.putLong(this.session, 8);
            }
            if (Integer.MAX_VALUE != this.inventoryFlag) {
                buffer.putLong(this.inventoryFlag, 8);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.baseSpeed = buffer.getIntUnsigned(8);
            this.qValue = buffer.getIntUnsigned(8);
            this.session = buffer.getIntUnsigned(8);
            this.inventoryFlag = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < this.cData.length) {
                int pid = buffer.getIntUnsigned(8);
                switch (pid) {
                    case 5: {
                        this.Tari = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 6: {
                        this.DR = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 7: {
                        this.RTcal = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 8: {
                        this.TRcal = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 9: {
                        this.PW = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 10: {
                        this.modulationDepth = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 11: {
                        this.Miller = buffer.getIntUnsigned(8);
                    }
                }
            }
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgBaseGetBaseband{baseSpeed=" + this.baseSpeed + ", qValue=" + this.qValue + ", session=" + this.session + ", inventoryFlag=" + this.inventoryFlag + ", Tari=" + this.Tari + ", DR=" + this.DR + ", RTcal=" + this.RTcal + ", TRcal=" + this.TRcal + ", PW=" + this.PW + ", modulationDepth=" + this.modulationDepth + ", Miller=" + this.Miller + '}';
    }
}

