/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.Param6bReadUserdata;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Arrays;
import java.util.Hashtable;

public class MsgBaseInventory6b
extends Message {
    private Long antennaEnable;
    private int inventoryMode;
    private int area;
    private Param6bReadUserdata readUserdata;
    private String hexMatchTid;
    private byte[] bMatchTid;
    private int timeout = Integer.MAX_VALUE;

    public MsgBaseInventory6b() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)64;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseInventory6b(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.inventoryMode = buffer.getIntUnsigned(8);
            this.area = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        byte[] paramData = new byte[2];
                        buffer.get(paramData);
                        this.readUserdata = new Param6bReadUserdata(paramData);
                        break;
                    }
                    case 2: {
                        byte[] paramData = new byte[8];
                        this.bMatchTid = buffer.get(paramData);
                        this.hexMatchTid = HexUtils.bytes2HexString(this.bMatchTid);
                        break;
                    }
                    case 23: {
                        this.timeout = buffer.getIntUnsigned(32);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public int getInventoryMode() {
        return this.inventoryMode;
    }

    public void setInventoryMode(int inventoryMode) {
        this.inventoryMode = inventoryMode;
    }

    public int getArea() {
        return this.area;
    }

    public void setArea(int area) {
        this.area = area;
    }

    public Param6bReadUserdata getReadUserdata() {
        return this.readUserdata;
    }

    public void setReadUserdata(Param6bReadUserdata readUserdata) {
        this.readUserdata = readUserdata;
    }

    public String getHexMatchTid() {
        return this.hexMatchTid;
    }

    public void setHexMatchTid(String hexMatchTid) {
        if (!StringUtils.isNullOfEmpty(hexMatchTid)) {
            this.hexMatchTid = hexMatchTid;
            this.bMatchTid = HexUtils.hexString2Bytes(this.hexMatchTid);
        }
    }

    public byte[] getbMatchTid() {
        return this.bMatchTid;
    }

    public void setbMatchTid(byte[] bMatchTid) {
        this.bMatchTid = bMatchTid;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.antennaEnable, 32);
        buffer.putLong(this.inventoryMode, 8);
        buffer.putLong(this.area, 8);
        if (null != this.readUserdata) {
            buffer.putInt(1, 8);
            byte[] tmpByte = this.readUserdata.toBytes();
            buffer.put(tmpByte);
        }
        if (this.bMatchTid != null && this.bMatchTid.length > 0) {
            buffer.putInt(2, 8);
            buffer.put(this.bMatchTid);
        }
        if (this.timeout != Integer.MAX_VALUE) {
            buffer.putInt(23, 8);
            buffer.putInt(this.timeout, 32);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter error.");
                this.put((byte)2, "Read parameter error.");
                this.put((byte)3, "Userdata parameter error.");
                this.put((byte)4, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }

    public String toString() {
        return "MsgBaseInventory6b{antennaEnable=" + this.antennaEnable + ", inventoryMode=" + this.inventoryMode + ", area=" + this.area + ", readUserdata=" + this.readUserdata + ", hexMatchTid='" + this.hexMatchTid + '\'' + ", bMatchTid=" + Arrays.toString(this.bMatchTid) + '}';
    }
}

