/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamAccessOperate;
import com.gg.reader.api.protocol.gx.ParamEpcFilter;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;
import java.util.List;

public class MsgBaseInventoryAndAccess
extends Message {
    private Long antennaEnable;
    private int inventoryMode;
    private ParamEpcFilter filter;
    private String hexPassword;
    private List<ParamAccessOperate> operateList;
    private int timeout = Integer.MAX_VALUE;

    public MsgBaseInventoryAndAccess() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)-93;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public int getInventoryMode() {
        return this.inventoryMode;
    }

    public void setInventoryMode(int inventoryMode) {
        this.inventoryMode = inventoryMode;
    }

    public ParamEpcFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ParamEpcFilter filter) {
        this.filter = filter;
    }

    public String getHexPassword() {
        return this.hexPassword;
    }

    public void setHexPassword(String hexPassword) {
        this.hexPassword = hexPassword;
    }

    public List<ParamAccessOperate> getOperateList() {
        return this.operateList;
    }

    public void setOperateList(List<ParamAccessOperate> operateList) {
        this.operateList = operateList;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void pack() {
        try {
            byte[] tmpByte;
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.antennaEnable, 32);
            buffer.putLong(this.inventoryMode, 8);
            if (null != this.filter) {
                buffer.putInt(1, 8);
                tmpByte = this.filter.toBytes();
                buffer.putInt(tmpByte.length, 16);
                buffer.put(tmpByte);
            }
            if (!StringUtils.isNullOfEmpty(this.hexPassword)) {
                buffer.putInt(2, 8);
                tmpByte = HexUtils.hexString2Bytes(this.hexPassword);
                buffer.put(tmpByte);
            }
            if (this.operateList != null && !this.operateList.isEmpty()) {
                for (int i = 0; i < this.operateList.size(); ++i) {
                    buffer.putInt(3 + i, 8);
                    byte[] bytes = this.operateList.get(i).toBytes();
                    buffer.putInt(bytes.length, 16);
                    buffer.put(bytes);
                }
            }
            if (this.timeout != Integer.MAX_VALUE) {
                buffer.putInt(23, 8);
                buffer.putInt(this.timeout, 32);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter error.");
                this.put((byte)2, "Filter parameter error.");
                this.put((byte)3, "TID parameter error.");
                this.put((byte)4, "User parameter error.");
                this.put((byte)5, "Reserve parameter error.");
                this.put((byte)6, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

