/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamEpcFilter;
import com.gg.reader.api.protocol.gx.ParamEpcReadEpc;
import com.gg.reader.api.protocol.gx.ParamEpcReadReserved;
import com.gg.reader.api.protocol.gx.ParamEpcReadTid;
import com.gg.reader.api.protocol.gx.ParamEpcReadUserdata;
import com.gg.reader.api.protocol.gx.ParamFastId;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgBaseInventoryEpc
extends Message {
    private Long antennaEnable;
    private int inventoryMode;
    private ParamEpcFilter filter;
    private ParamEpcReadTid readTid;
    private ParamEpcReadUserdata readUserdata;
    private ParamEpcReadReserved readReserved;
    private String hexPassword;
    private int monzaQtPeek = Integer.MAX_VALUE;
    private int rfmicron = Integer.MAX_VALUE;
    private int emSensor = Integer.MAX_VALUE;
    private ParamEpcReadEpc readEpc;
    private ParamFastId paramFastId;
    private int ctesius = Integer.MAX_VALUE;
    private int seed;
    private int quanray;
    private int timeout = Integer.MAX_VALUE;
    private int encryptionVerification = Integer.MAX_VALUE;
    private int EPC_2V2_Authenticate = Integer.MAX_VALUE;
    private int readTs = Integer.MAX_VALUE;
    private int enableMultiFilter = Integer.MAX_VALUE;
    private int quanray2 = Integer.MAX_VALUE;
    private int accessReadFlag = Integer.MAX_VALUE;
    private int stayCarrierWave = Integer.MAX_VALUE;

    public MsgBaseInventoryEpc() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)16;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseInventoryEpc(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.inventoryMode = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        int len = buffer.getIntUnsigned(16);
                        byte[] paramData = new byte[len];
                        buffer.get(paramData);
                        this.filter = new ParamEpcFilter(paramData);
                        break;
                    }
                    case 2: {
                        byte[] paramData = new byte[2];
                        buffer.get(paramData);
                        this.readTid = new ParamEpcReadTid(paramData);
                        break;
                    }
                    case 3: {
                        byte[] paramData = new byte[3];
                        buffer.get(paramData);
                        this.readUserdata = new ParamEpcReadUserdata(paramData);
                        break;
                    }
                    case 4: {
                        byte[] paramData = new byte[3];
                        buffer.get(paramData);
                        this.readReserved = new ParamEpcReadReserved(paramData);
                        break;
                    }
                    case 5: {
                        byte[] paramData = new byte[4];
                        buffer.get(paramData);
                        this.hexPassword = HexUtils.bytes2HexString(paramData);
                        break;
                    }
                    case 6: {
                        this.monzaQtPeek = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 7: {
                        this.rfmicron = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 8: {
                        this.emSensor = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 9: {
                        byte[] paramData = new byte[3];
                        buffer.get(paramData);
                        this.readEpc = new ParamEpcReadEpc(paramData);
                        break;
                    }
                    case 10: {
                        byte[] paramData = new byte[2];
                        buffer.get(paramData);
                        this.paramFastId = new ParamFastId(paramData);
                        break;
                    }
                    case 18: {
                        this.ctesius = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 19: {
                        this.seed = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 22: {
                        this.quanray = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 23: {
                        this.timeout = buffer.getIntUnsigned(32);
                        break;
                    }
                    case 24: {
                        this.enableMultiFilter = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 32: {
                        this.EPC_2V2_Authenticate = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public int getInventoryMode() {
        return this.inventoryMode;
    }

    public void setInventoryMode(int inventoryMode) {
        this.inventoryMode = inventoryMode;
    }

    public ParamEpcFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ParamEpcFilter filter) {
        this.filter = filter;
    }

    public ParamEpcReadTid getReadTid() {
        return this.readTid;
    }

    public void setReadTid(ParamEpcReadTid readTid) {
        this.readTid = readTid;
    }

    public ParamEpcReadUserdata getReadUserdata() {
        return this.readUserdata;
    }

    public void setReadUserdata(ParamEpcReadUserdata readUserdata) {
        this.readUserdata = readUserdata;
    }

    public ParamEpcReadReserved getReadReserved() {
        return this.readReserved;
    }

    public void setReadReserved(ParamEpcReadReserved readReserved) {
        this.readReserved = readReserved;
    }

    public String getHexPassword() {
        return this.hexPassword;
    }

    public void setHexPassword(String hexPassword) {
        this.hexPassword = hexPassword;
    }

    public int getMonzaQtPeek() {
        return this.monzaQtPeek;
    }

    public void setMonzaQtPeek(int monzaQtPeek) {
        this.monzaQtPeek = monzaQtPeek;
    }

    public int getRfmicron() {
        return this.rfmicron;
    }

    public void setRfmicron(int rfmicron) {
        this.rfmicron = rfmicron;
    }

    public int getEmSensor() {
        return this.emSensor;
    }

    public void setEmSensor(int emSensor) {
        this.emSensor = emSensor;
    }

    public int getCtesius() {
        return this.ctesius;
    }

    public void setCtesius(int ctesius) {
        this.ctesius = ctesius;
    }

    public ParamEpcReadEpc getReadEpc() {
        return this.readEpc;
    }

    public void setReadEpc(ParamEpcReadEpc readEpc) {
        this.readEpc = readEpc;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public ParamFastId getParamFastId() {
        return this.paramFastId;
    }

    public void setParamFastId(ParamFastId paramFastId) {
        this.paramFastId = paramFastId;
    }

    public int getQuanray() {
        return this.quanray;
    }

    public void setQuanray(int quanray) {
        this.quanray = quanray;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getEPC_2V2_Authenticate() {
        return this.EPC_2V2_Authenticate;
    }

    public void setEPC_2V2_Authenticate(int EPC_2V2_Authenticate) {
        this.EPC_2V2_Authenticate = EPC_2V2_Authenticate;
    }

    public int getReadTs() {
        return this.readTs;
    }

    public void setReadTs(int readTs) {
        this.readTs = readTs;
    }

    public int getEnableMultiFilter() {
        return this.enableMultiFilter;
    }

    public void setEnableMultiFilter(int enableMultiFilter) {
        this.enableMultiFilter = enableMultiFilter;
    }

    public int getQuanray2() {
        return this.quanray2;
    }

    public void setQuanray2(int quanray2) {
        this.quanray2 = quanray2;
    }

    public int getEncryptionVerification() {
        return this.encryptionVerification;
    }

    public void setEncryptionVerification(int encryptionVerification) {
        this.encryptionVerification = encryptionVerification;
    }

    public int getAccessReadFlag() {
        return this.accessReadFlag;
    }

    public void setAccessReadFlag(int accessReadFlag) {
        this.accessReadFlag = accessReadFlag;
    }

    public int getStayCarrierWave() {
        return this.stayCarrierWave;
    }

    public void setStayCarrierWave(int stayCarrierWave) {
        this.stayCarrierWave = stayCarrierWave;
    }

    @Override
    public void pack() {
        try {
            byte[] tmpByte;
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.antennaEnable, 32);
            buffer.putLong(this.inventoryMode, 8);
            if (null != this.filter) {
                buffer.putInt(1, 8);
                tmpByte = this.filter.toBytes();
                buffer.putInt(tmpByte.length, 16);
                buffer.put(tmpByte);
            }
            if (null != this.readTid) {
                buffer.putInt(2, 8);
                tmpByte = this.readTid.toBytes();
                buffer.put(tmpByte);
            }
            if (null != this.readUserdata) {
                buffer.putInt(3, 8);
                tmpByte = this.readUserdata.toBytes();
                buffer.put(tmpByte);
            }
            if (null != this.readReserved) {
                buffer.putInt(4, 8);
                tmpByte = this.readReserved.toBytes();
                buffer.put(tmpByte);
            }
            if (!StringUtils.isNullOfEmpty(this.hexPassword)) {
                buffer.putInt(5, 8);
                tmpByte = HexUtils.hexString2Bytes(this.hexPassword);
                buffer.put(tmpByte);
            }
            if (this.monzaQtPeek != Integer.MAX_VALUE) {
                buffer.putInt(6, 8);
                buffer.putLong(this.monzaQtPeek, 8);
            }
            if (this.rfmicron != Integer.MAX_VALUE) {
                buffer.putInt(7, 8);
                buffer.putLong(this.rfmicron, 8);
            }
            if (this.emSensor != Integer.MAX_VALUE) {
                buffer.putInt(8, 8);
                buffer.putLong(this.emSensor, 8);
            }
            if (null != this.readEpc) {
                buffer.putInt(9, 8);
                tmpByte = this.readEpc.toBytes();
                buffer.put(tmpByte);
            }
            if (null != this.paramFastId) {
                buffer.putInt(10, 8);
                tmpByte = this.paramFastId.toBytes();
                buffer.put(tmpByte);
            }
            if (this.ctesius != Integer.MAX_VALUE) {
                buffer.putInt(18, 8);
                buffer.putInt(this.ctesius, 8);
            }
            if (this.seed != 0) {
                buffer.putInt(19, 8);
                buffer.putInt(this.seed, 8);
            }
            if (this.quanray != 0) {
                buffer.putInt(22, 8);
                buffer.putInt(this.quanray, 8);
            }
            if (this.timeout != Integer.MAX_VALUE) {
                buffer.putInt(23, 8);
                buffer.putInt(this.timeout, 32);
            }
            if (this.enableMultiFilter != Integer.MAX_VALUE) {
                buffer.putInt(24, 8);
                buffer.putInt(this.enableMultiFilter, 8);
            }
            if (this.encryptionVerification != Integer.MAX_VALUE) {
                buffer.putInt(25, 8);
                buffer.putInt(this.encryptionVerification, 8);
            }
            if (this.EPC_2V2_Authenticate != Integer.MAX_VALUE) {
                buffer.putInt(32, 8);
                buffer.putInt(this.EPC_2V2_Authenticate, 8);
            }
            if (this.readTs != Integer.MAX_VALUE) {
                buffer.putInt(35, 8);
                buffer.putInt(this.readTs, 8);
            }
            if (this.quanray2 != Integer.MAX_VALUE) {
                buffer.putInt(37, 8);
                buffer.putInt(this.quanray2, 8);
            }
            if (this.accessReadFlag != Integer.MAX_VALUE) {
                buffer.putInt(41, 8);
                buffer.putInt(this.accessReadFlag, 8);
            }
            if (this.stayCarrierWave != Integer.MAX_VALUE) {
                buffer.putInt(42, 8);
                buffer.putInt(this.stayCarrierWave, 8);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter error.");
                this.put((byte)2, "Filter parameter error.");
                this.put((byte)3, "TID parameter error.");
                this.put((byte)4, "User parameter error.");
                this.put((byte)5, "Reserve parameter error.");
                this.put((byte)6, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }

    public String toString() {
        return "MsgBaseInventoryEpc{antennaEnable=" + this.antennaEnable + ", inventoryMode=" + this.inventoryMode + ", filter=" + this.filter + ", readTid=" + this.readTid + ", readUserdata=" + this.readUserdata + ", readReserved=" + this.readReserved + ", hexPassword='" + this.hexPassword + '\'' + ", monzaQtPeek=" + this.monzaQtPeek + ", rfmicron=" + this.rfmicron + ", emSensor=" + this.emSensor + ", readEpc=" + this.readEpc + ", paramFastId=" + this.paramFastId + ", ctesius=" + this.ctesius + ", seed=" + this.seed + ", quanray=" + this.quanray + '}';
    }
}

