/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgBaseLogOnOff
extends Message {
    private int operationType;
    private int antennaSwitching;
    private int antennaStatus;
    private int moduleTemperature;

    public MsgBaseLogOnOff() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)15;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getOperationType() {
        return this.operationType;
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public int getAntennaSwitching() {
        return this.antennaSwitching;
    }

    public void setAntennaSwitching(int antennaSwitching) {
        this.antennaSwitching = antennaSwitching;
    }

    public int getAntennaStatus() {
        return this.antennaStatus;
    }

    public void setAntennaStatus(int antennaStatus) {
        this.antennaStatus = antennaStatus;
    }

    public int getModuleTemperature() {
        return this.moduleTemperature;
    }

    public void setModuleTemperature(int moduleTemperature) {
        this.moduleTemperature = moduleTemperature;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(this.operationType, 8);
        if (this.operationType == 1) {
            buffer.putInt(1, 8);
            buffer.putLong(this.antennaSwitching, 8);
            buffer.putInt(2, 8);
            buffer.putLong(this.antennaStatus, 8);
            buffer.putInt(3, 8);
            buffer.putLong(this.moduleTemperature, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "failure.");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(8);
            while (buffer.position() / 8 < this.cData.length) {
                int pid = buffer.getIntUnsigned(8);
                switch (pid) {
                    case 1: {
                        this.antennaSwitching = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 2: {
                        this.antennaStatus = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 3: {
                        this.moduleTemperature = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
    }
}

