/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgBaseSetBaseband
extends Message {
    private int baseSpeed = Integer.MAX_VALUE;
    private int qValue = Integer.MAX_VALUE;
    private int session = Integer.MAX_VALUE;
    private int inventoryFlag = Integer.MAX_VALUE;
    private int Tari = Integer.MAX_VALUE;
    private int DR = Integer.MAX_VALUE;
    private int RTcal = Integer.MAX_VALUE;
    private int TRcal = Integer.MAX_VALUE;
    private int PW = Integer.MAX_VALUE;
    private int modulationDepth = Integer.MAX_VALUE;
    private int Miller = Integer.MAX_VALUE;
    private int powerDownSave = Integer.MAX_VALUE;

    public MsgBaseSetBaseband() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)11;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseSetBaseband(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        this.baseSpeed = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 2: {
                        this.qValue = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 3: {
                        this.session = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 4: {
                        this.inventoryFlag = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBaseSpeed() {
        return this.baseSpeed;
    }

    public void setBaseSpeed(int baseSpeed) {
        this.baseSpeed = baseSpeed;
    }

    public int getqValue() {
        return this.qValue;
    }

    public void setqValue(int qValue) {
        this.qValue = qValue;
    }

    public int getSession() {
        return this.session;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public int getInventoryFlag() {
        return this.inventoryFlag;
    }

    public void setInventoryFlag(int inventoryFlag) {
        this.inventoryFlag = inventoryFlag;
    }

    public int getTari() {
        return this.Tari;
    }

    public void setTari(int tari) {
        this.Tari = tari;
    }

    public int getDR() {
        return this.DR;
    }

    public void setDR(int DR) {
        this.DR = DR;
    }

    public int getRTcal() {
        return this.RTcal;
    }

    public void setRTcal(int RTcal) {
        this.RTcal = RTcal;
    }

    public int getTRcal() {
        return this.TRcal;
    }

    public void setTRcal(int TRcal) {
        this.TRcal = TRcal;
    }

    public int getPW() {
        return this.PW;
    }

    public void setPW(int PW) {
        this.PW = PW;
    }

    public int getModulationDepth() {
        return this.modulationDepth;
    }

    public void setModulationDepth(int modulationDepth) {
        this.modulationDepth = modulationDepth;
    }

    public int getMiller() {
        return this.Miller;
    }

    public void setMiller(int miller) {
        this.Miller = miller;
    }

    public int getPowerDownSave() {
        return this.powerDownSave;
    }

    public void setPowerDownSave(int powerDownSave) {
        this.powerDownSave = powerDownSave;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (Integer.MAX_VALUE != this.baseSpeed) {
            buffer.putInt(1, 8);
            buffer.putLong(this.baseSpeed, 8);
        }
        if (Integer.MAX_VALUE != this.qValue) {
            buffer.putInt(2, 8);
            buffer.putLong(this.qValue, 8);
        }
        if (Integer.MAX_VALUE != this.session) {
            buffer.putInt(3, 8);
            buffer.putLong(this.session, 8);
        }
        if (Integer.MAX_VALUE != this.inventoryFlag) {
            buffer.putInt(4, 8);
            buffer.putLong(this.inventoryFlag, 8);
        }
        if (Integer.MAX_VALUE != this.Tari) {
            buffer.putInt(5, 8);
            buffer.putLong(this.Tari, 8);
        }
        if (Integer.MAX_VALUE != this.DR) {
            buffer.putInt(6, 8);
            buffer.putLong(this.DR, 8);
        }
        if (Integer.MAX_VALUE != this.RTcal) {
            buffer.putInt(7, 8);
            buffer.putLong(this.RTcal, 8);
        }
        if (Integer.MAX_VALUE != this.TRcal) {
            buffer.putInt(8, 8);
            buffer.putLong(this.TRcal, 8);
        }
        if (Integer.MAX_VALUE != this.PW) {
            buffer.putInt(9, 8);
            buffer.putLong(this.PW, 8);
        }
        if (Integer.MAX_VALUE != this.modulationDepth) {
            buffer.putInt(10, 8);
            buffer.putLong(this.modulationDepth, 8);
        }
        if (Integer.MAX_VALUE != this.Miller) {
            buffer.putInt(11, 8);
            buffer.putLong(this.Miller, 8);
        }
        if (Integer.MAX_VALUE != this.powerDownSave) {
            buffer.putInt(255, 8);
            buffer.putInt(this.powerDownSave, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Parameter not supported.");
                this.put((byte)2, "Q value parameter error.");
                this.put((byte)3, "Session parameter error.");
                this.put((byte)4, "Inventory parameter error.");
                this.put((byte)5, "Other error.");
                this.put((byte)6, "Save failure.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

