/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamGJbSimCreatePwd;
import com.gg.reader.api.protocol.gx.ParamGJbSimDataDecrypt;
import com.gg.reader.api.protocol.gx.ParamGJbSimDataEncrypt;
import com.gg.reader.api.protocol.gx.ParamGJbSimEditPwd;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;

public class MsgBaseSetGJbSIM
extends Message {
    private String managerPwd;
    private ParamGJbSimEditPwd editPwd;
    private ParamGJbSimCreatePwd createPwd;
    private ParamGJbSimDataEncrypt dataEncrypt;
    private ParamGJbSimDataDecrypt dataDecrypt;
    private String result;

    public MsgBaseSetGJbSIM() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)100;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getManagerPwd() {
        return this.managerPwd;
    }

    public void setManagerPwd(String managerPwd) {
        this.managerPwd = managerPwd;
    }

    public ParamGJbSimEditPwd getEditPwd() {
        return this.editPwd;
    }

    public void setEditPwd(ParamGJbSimEditPwd editPwd) {
        this.editPwd = editPwd;
    }

    public ParamGJbSimCreatePwd getCreatePwd() {
        return this.createPwd;
    }

    public void setCreatePwd(ParamGJbSimCreatePwd createPwd) {
        this.createPwd = createPwd;
    }

    public ParamGJbSimDataEncrypt getDataEncrypt() {
        return this.dataEncrypt;
    }

    public void setDataEncrypt(ParamGJbSimDataEncrypt dataEncrypt) {
        this.dataEncrypt = dataEncrypt;
    }

    public ParamGJbSimDataDecrypt getDataDecrypt() {
        return this.dataDecrypt;
    }

    public void setDataDecrypt(ParamGJbSimDataDecrypt dataDecrypt) {
        this.dataDecrypt = dataDecrypt;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public void pack() {
        byte[] bytes;
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (!StringUtils.isNullOfEmpty(this.managerPwd)) {
            bytes = HexUtils.hexString2Bytes(this.managerPwd);
            buffer.putInt(1, 8);
            buffer.put(bytes);
        }
        if (this.editPwd != null) {
            buffer.putInt(2, 8);
            buffer.put(this.editPwd.toBytes());
        }
        if (this.createPwd != null) {
            buffer.putInt(3, 8);
            buffer.put(this.createPwd.toBytes());
        }
        if (this.dataEncrypt != null) {
            buffer.putInt(4, 8);
            bytes = this.dataEncrypt.toBytes();
            buffer.putInt(bytes.length, 16);
            buffer.put(bytes);
        }
        if (this.dataDecrypt != null) {
            buffer.putInt(5, 8);
            bytes = this.dataDecrypt.toBytes();
            buffer.putInt(bytes.length, 16);
            buffer.put(bytes);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            switch (this.cData[0]) {
                case 1: {
                    byte c1 = this.cData[1];
                    this.setRtCode(c1);
                    this.setRtMsg(c1 == 0 ? "init success" : (c1 == 1 ? "pwd error" : (c1 == 2 ? "init fail" : "other error")));
                    break;
                }
                case 2: {
                    byte c1 = this.cData[1];
                    this.setRtCode(c1);
                    this.setRtMsg(c1 == 0 ? "edit success" : "edit fail");
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    BitBuffer buffer = BitBuffer.wrap(this.cData);
                    buffer.position(8);
                    int len = buffer.getIntUnsigned(16);
                    if (len <= 0) break;
                    int c1 = buffer.getIntUnsigned(8);
                    this.setRtCode((byte)c1);
                    this.setRtMsg(c1 == 0 ? "success" : (c1 == 1 ? "not init" : "other error"));
                    if (c1 != 0) break;
                    byte[] bytes = new byte[len - 1];
                    buffer.get(bytes);
                    this.result = HexUtils.bytes2HexString(bytes);
                    break;
                }
            }
        }
    }
}

