/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.StringUtils;
import java.util.HashMap;

public class MsgHDSystemSet
extends Message {
    private int autoShutdownTime = -1;
    private int buzzerSwitch = -1;
    private String bluetoothName;
    private int batteryLevel = -1;
    private int cusPid = -1;
    private int cusParam = -1;
    private byte[] cusResult;

    public MsgHDSystemSet() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "1111";
            this.msgType.msgId = 0;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAutoShutdownTime() {
        return this.autoShutdownTime;
    }

    public void setAutoShutdownTime(int autoShutdownTime) {
        this.autoShutdownTime = autoShutdownTime;
    }

    public int getBuzzerSwitch() {
        return this.buzzerSwitch;
    }

    public void setBuzzerSwitch(int buzzerSwitch) {
        this.buzzerSwitch = buzzerSwitch;
    }

    public String getBluetoothName() {
        return this.bluetoothName;
    }

    public void setBluetoothName(String bluetoothName) {
        this.bluetoothName = bluetoothName;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public void setBatteryLevel(int batteryLevel) {
        this.batteryLevel = batteryLevel;
    }

    public int getCusPid() {
        return this.cusPid;
    }

    public void setCusPid(int cusPid) {
        this.cusPid = cusPid;
    }

    public int getCusParam() {
        return this.cusParam;
    }

    public void setCusParam(int cusParam) {
        this.cusParam = cusParam;
    }

    public byte[] getCusResult() {
        return this.cusResult;
    }

    public void setCusResult(byte[] cusResult) {
        this.cusResult = cusResult;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (this.autoShutdownTime != -1) {
            buffer.putInt(1, 8);
            buffer.putInt(this.autoShutdownTime, 8);
        }
        if (this.buzzerSwitch != -1) {
            buffer.putInt(2, 8);
            buffer.putInt(this.buzzerSwitch, 8);
        }
        if (!StringUtils.isNullOfEmpty(this.bluetoothName)) {
            buffer.putInt(3, 8);
            buffer.putInt(this.bluetoothName.length(), 8);
            buffer.put(this.bluetoothName);
        }
        if (this.batteryLevel != -1) {
            buffer.putInt(4, 8);
            buffer.putInt(this.batteryLevel, 8);
        }
        if (this.cusPid != -1) {
            buffer.putInt(this.cusPid, 8);
            buffer.putInt(this.cusParam, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        HashMap<Byte, String> dicErrorMsg = new HashMap<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Failure.");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            int pid = buffer.getIntUnsigned(8);
            switch (pid) {
                case 1: 
                case 2: 
                case 3: {
                    byte code = (byte)buffer.getIntUnsigned(8);
                    this.setRtCode(code);
                    if (!dicErrorMsg.containsKey(code)) break;
                    this.setRtMsg((String)dicErrorMsg.get(code));
                    break;
                }
                case 4: {
                    this.setRtCode((byte)0);
                    this.batteryLevel = buffer.getIntUnsigned(8);
                    break;
                }
                default: {
                    this.setRtCode((byte)0);
                    int len = buffer.getIntUnsigned(8);
                    this.cusResult = new byte[len];
                    buffer.get(this.cusResult);
                }
            }
        }
    }
}

