/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgTestSerialNoSet
extends Message {
    private String readerSerialNumber;
    private String tuYaPid;
    private String tuYaUuid;
    private String tuYaAuthKey;
    private String tuYaShortUrl;

    public MsgTestSerialNoSet() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0101";
            this.msgType.msgId = (byte)16;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgTestSerialNoSet(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            int snLen = buffer.getIntUnsigned(16);
            if (snLen > 0) {
                this.readerSerialNumber = new String(buffer.get(new byte[snLen]), "ASCII");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getReaderSerialNumber() {
        return this.readerSerialNumber;
    }

    public void setReaderSerialNumber(String readerSerialNumber) {
        this.readerSerialNumber = readerSerialNumber;
    }

    public String getTuYaPid() {
        return this.tuYaPid;
    }

    public void setTuYaPid(String tuYaPid) {
        this.tuYaPid = tuYaPid;
    }

    public String getTuYaUuid() {
        return this.tuYaUuid;
    }

    public void setTuYaUuid(String tuYaUuid) {
        this.tuYaUuid = tuYaUuid;
    }

    public String getTuYaAuthKey() {
        return this.tuYaAuthKey;
    }

    public void setTuYaAuthKey(String tuYaAuthKey) {
        this.tuYaAuthKey = tuYaAuthKey;
    }

    public String getTuYaShortUrl() {
        return this.tuYaShortUrl;
    }

    public void setTuYaShortUrl(String tuYaShortUrl) {
        this.tuYaShortUrl = tuYaShortUrl;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (!StringUtils.isNullOfEmpty(this.readerSerialNumber)) {
            buffer.putInt(this.readerSerialNumber.length(), 16);
            buffer.put(this.readerSerialNumber);
            if (!StringUtils.isNullOfEmpty(this.tuYaPid)) {
                buffer.putInt(1, 8);
                buffer.putInt(this.tuYaPid.length(), 16);
                buffer.put(this.tuYaPid);
            }
            if (!StringUtils.isNullOfEmpty(this.tuYaUuid)) {
                buffer.putInt(2, 8);
                buffer.putInt(this.tuYaUuid.length(), 16);
                buffer.put(this.tuYaUuid);
            }
            if (!StringUtils.isNullOfEmpty(this.tuYaAuthKey)) {
                buffer.putInt(3, 8);
                buffer.putInt(this.tuYaAuthKey.length(), 16);
                buffer.put(this.tuYaAuthKey);
            }
            if (!StringUtils.isNullOfEmpty(this.tuYaShortUrl)) {
                buffer.putInt(4, 8);
                buffer.putInt(this.tuYaShortUrl.length(), 16);
                buffer.put(this.tuYaShortUrl);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

