/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.utils;

public class HexUtils {
    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean isHexString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (HexUtils.isHexDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static byte charToByte(char c) {
        c = Character.toUpperCase(c);
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte hex2Byte(String hex) {
        if (hex.length() < 2) {
            hex = "00" + hex;
        }
        if (hex.length() > 2) {
            hex = hex.substring(0, 2);
        }
        return (byte)(HexUtils.charToByte(hex.charAt(0)) << 4 | HexUtils.charToByte(hex.charAt(1)));
    }

    public static short hex2Short(String hex) {
        if (hex.length() < 4) {
            hex = "0000" + hex;
        }
        if (hex.length() > 4) {
            hex = hex.substring(0, 4);
        }
        return (short)(HexUtils.charToByte(hex.charAt(0)) << 12 | HexUtils.charToByte(hex.charAt(1)) << 8 | HexUtils.charToByte(hex.charAt(2)) << 4 | HexUtils.charToByte(hex.charAt(3)));
    }

    public static int hex2Int(String hex) {
        if (hex.length() < 8) {
            hex = "00000000" + hex;
        }
        if (hex.length() > 8) {
            hex = hex.substring(0, 8);
        }
        return HexUtils.charToByte(hex.charAt(0)) << 28 | HexUtils.charToByte(hex.charAt(1)) << 24 | HexUtils.charToByte(hex.charAt(2)) << 20 | HexUtils.charToByte(hex.charAt(3)) << 16 | HexUtils.charToByte(hex.charAt(4)) << 12 | HexUtils.charToByte(hex.charAt(5)) << 8 | HexUtils.charToByte(hex.charAt(6)) << 4 | HexUtils.charToByte(hex.charAt(7));
    }

    public static long hex2Long(String hex) {
        if (hex.length() < 16) {
            hex = "0000000000000000" + hex;
        }
        if (hex.length() > 16) {
            hex = hex.substring(0, 16);
        }
        long value = HexUtils.charToByte(hex.charAt(0)) << 28 | HexUtils.charToByte(hex.charAt(1)) << 24 | HexUtils.charToByte(hex.charAt(2)) << 20 | HexUtils.charToByte(hex.charAt(3)) << 16 | HexUtils.charToByte(hex.charAt(4)) << 12 | HexUtils.charToByte(hex.charAt(5)) << 8 | HexUtils.charToByte(hex.charAt(6)) << 4 | HexUtils.charToByte(hex.charAt(7));
        value <<= 16;
        value |= (long)(HexUtils.charToByte(hex.charAt(8)) << 12 | HexUtils.charToByte(hex.charAt(9)) << 8 | HexUtils.charToByte(hex.charAt(10)) << 4 | HexUtils.charToByte(hex.charAt(11)));
        value <<= 16;
        return value |= (long)(HexUtils.charToByte(hex.charAt(12)) << 12 | HexUtils.charToByte(hex.charAt(13)) << 8 | HexUtils.charToByte(hex.charAt(14)) << 4 | HexUtils.charToByte(hex.charAt(15)));
    }

    public static String byte2Hex(byte b) {
        String rt = "";
        try {
            rt = Integer.toHexString(b & 0xFF);
            if (rt.length() == 1) {
                rt = '0' + rt;
            }
            rt = rt.toUpperCase();
        }
        catch (Exception ex) {
            return "";
        }
        return rt;
    }

    public static String short2Hex(short value) {
        String rt = "";
        rt = HexUtils.byte2Hex((byte)(value >> 8 & 0xFF));
        rt = rt + HexUtils.byte2Hex((byte)(value & 0xFF));
        return rt;
    }

    public static String int2Hex(int value) {
        String rt = "";
        rt = HexUtils.short2Hex((short)(value >> 16 & 0xFFFF));
        rt = rt + HexUtils.short2Hex((short)(value & 0xFFFF));
        return rt;
    }

    public static String long2Hex(long value) {
        String rt = "";
        rt = HexUtils.int2Hex((int)(value >> 32));
        rt = rt + HexUtils.int2Hex((int)value);
        return rt;
    }

    public static byte[] hexString2Bytes(String hexString) {
        if (null == hexString || hexString.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String newString = "";
        for (int i = 0; i < hexString.length(); ++i) {
            char c = hexString.charAt(i);
            if (!HexUtils.isHexDigit(c)) continue;
            newString = newString + c;
        }
        if (newString.length() % 2 != 0) {
            newString = newString.substring(0, newString.length() - 1);
        }
        int byteLength = newString.length() / 2;
        byte[] bytes = new byte[byteLength];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            String hex = newString.substring(j, j + 2);
            bytes[i] = HexUtils.hex2Byte(hex);
            j += 2;
        }
        return bytes;
    }

    public static String bytes2HexString(byte[] bArray, int offset, int length) {
        if (null == bArray || bArray.length <= 0) {
            throw new IllegalArgumentException();
        }
        if (offset + length > bArray.length) {
            throw new IllegalArgumentException();
        }
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer temp = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            temp.append(HexUtils.byte2Hex(bArray[i]));
        }
        return temp.toString();
    }

    public static String bytes2HexString(byte[] bArray) {
        if (null == bArray || bArray.length <= 0) {
            throw new IllegalArgumentException();
        }
        return HexUtils.bytes2HexString(bArray, 0, bArray.length);
    }

    public static short bytes2Short(byte[] bArray, int offset) {
        if (null == bArray || bArray.length < offset + 2) {
            throw new IllegalArgumentException();
        }
        return (short)(bArray[offset] << 8 & 0xFF00 | bArray[offset + 1] & 0xFF);
    }

    public static short bytes2Short(byte[] bArray) {
        return HexUtils.bytes2Short(bArray, 0);
    }

    public static byte[] short2Bytes(short value) {
        byte[] result = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static int bytes2Int(byte[] bArray, int offset) {
        if (null == bArray || bArray.length < offset + 4) {
            throw new IllegalArgumentException();
        }
        return bArray[offset] << 24 & 0xFF000000 | bArray[offset + 1] << 16 & 0xFF0000 | bArray[offset + 2] << 8 & 0xFF00 | bArray[offset + 3] & 0xFF;
    }

    public static int bytes2Int(byte[] bArray) {
        return HexUtils.bytes2Int(bArray, 0);
    }

    public static byte[] int2Bytes(int value) {
        byte[] result = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static byte[] long2Bytes(long value) {
        byte[] result = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return result;
    }
}

