/*
 * Decompiled with CFR 0.152.
 */
package com.peripheral.ble;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.le.ScanResult;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgTestWorkModeInit;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.ThreadPoolUtils;
import com.peripheral.ble.BleServiceCallback;
import com.peripheral.ble.BluetoothCentralManager;
import com.peripheral.ble.BluetoothPeripheral;
import com.peripheral.ble.BluetoothPeripheralCallback;
import com.peripheral.ble.CharacteristicProperty;
import com.peripheral.ble.GattStatus;
import com.peripheral.ble.Logger;
import com.peripheral.ble.WriteType;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public class BleDevice
extends CommunicationInterface {
    private BluetoothCentralManager central;
    private BluetoothPeripheral mPeripheral;
    private BluetoothGattCharacteristic readCharacteristic;
    private BluetoothGattCharacteristic writeCharacteristic;
    private BluetoothGattCharacteristic notifyCharacteristic;
    private String serviceUuid = null;
    private BleServiceCallback serviceCallback;
    private ScanResult scanResult;
    private String initParam;
    private BluetoothPeripheralCallback peripheralCallback = new BluetoothPeripheralCallback(){

        @Override
        public void onServicesDiscovered(BluetoothPeripheral peripheral) {
            if (BleDevice.this.serviceUuid != null) {
                List<BluetoothGattService> services = peripheral.getServices();
                for (BluetoothGattService service : services) {
                    if (!service.getUuid().toString().equals(BleDevice.this.serviceUuid)) continue;
                    BleDevice.this.findCharacteristic(service);
                }
            }
            if (BleDevice.this.serviceCallback != null) {
                BleDevice.this.serviceCallback.onServicesDiscovered(peripheral);
            }
            BleDevice.this.setDataDispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCharacteristicUpdate(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, GattStatus status) {
            Log.e((String)("read-" + Thread.currentThread().getName()), (String)HexUtils.bytes2HexString(value));
            try {
                Object object = BleDevice.this.lockRingBuffer;
                synchronized (object) {
                    while (value.length + BleDevice.this.ringBuffer.getDataCount() > 0x100000) {
                        BleDevice.this.lockRingBuffer.wait(10000L);
                    }
                    BleDevice.this.ringBuffer.WriteBuffer(value, 0, value.length);
                    BleDevice.this.lockRingBuffer.notify();
                }
                if (BleDevice.this.onRevCommand != null) {
                    BleDevice.this.onRevCommand.revCommand(value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void onConnectionUpdated(BluetoothPeripheral peripheral, int interval, int latency, int timeout, GattStatus status) {
            if (BleDevice.this.serviceCallback != null) {
                BleDevice.this.serviceCallback.onConnectionUpdated(peripheral, status);
            }
            if (status == GattStatus.SUCCESS && !BleDevice.this.isNotifying()) {
                BleDevice.this.setNotify(true);
            }
        }
    };

    public BleDevice(BluetoothCentralManager central, BluetoothPeripheral mPeripheral) {
        this.central = central;
        this.mPeripheral = mPeripheral;
    }

    public BleServiceCallback getServiceCallback() {
        return this.serviceCallback;
    }

    public void setServiceCallback(BleServiceCallback serviceCallback) {
        this.serviceCallback = serviceCallback;
    }

    public boolean setMtu(int mtu) {
        if (this.mPeripheral != null) {
            return this.mPeripheral.requestMtu(mtu);
        }
        return false;
    }

    public boolean isNotifying() {
        if (this.mPeripheral != null && this.notifyCharacteristic != null) {
            return this.mPeripheral.isNotifying(this.notifyCharacteristic);
        }
        return false;
    }

    public boolean setNotify(boolean enable) {
        if (this.mPeripheral != null && this.notifyCharacteristic != null) {
            return this.mPeripheral.setNotify(this.notifyCharacteristic, enable);
        }
        return false;
    }

    public void setDataDispose() {
        if (!this.keepReceived) {
            this.keepReceived = true;
            this.startProcess();
        }
    }

    public void findCharacteristic(BluetoothGattService service) {
        for (BluetoothGattCharacteristic characteristic : service.getCharacteristics()) {
            if (CharacteristicProperty.isREAD(characteristic.getProperties()) && this.readCharacteristic == null) {
                Logger.e(characteristic.getUuid().toString(), "READ");
                this.readCharacteristic = characteristic;
            }
            if ((CharacteristicProperty.isWRITE(characteristic.getProperties()) || CharacteristicProperty.isWRITE_NO_RESPONSE(characteristic.getProperties())) && this.writeCharacteristic == null) {
                Logger.e(characteristic.getUuid().toString(), "WRITE = >" + characteristic.getWriteType());
                this.writeCharacteristic = characteristic;
            }
            if (!CharacteristicProperty.isNOTIFY(characteristic.getProperties()) && !CharacteristicProperty.isINDICATE(characteristic.getProperties()) || this.notifyCharacteristic != null) continue;
            Logger.e(characteristic.getUuid().toString(), "NOTIFY,INDICATE");
            this.notifyCharacteristic = characteristic;
        }
        if (this.initParam != null) {
            this.send(new MsgTestWorkModeInit(this.initParam, 0));
        }
    }

    public ScanResult getScanResult() {
        return this.scanResult;
    }

    public void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
    }

    public String getServiceUuid() {
        return this.serviceUuid;
    }

    public void setServiceUuid(String serviceUuid) {
        this.serviceUuid = serviceUuid;
    }

    public BluetoothPeripheral getmPeripheral() {
        return this.mPeripheral;
    }

    public void setmPeripheral(BluetoothPeripheral mPeripheral) {
        this.mPeripheral = mPeripheral;
    }

    public BluetoothCentralManager getCentral() {
        return this.central;
    }

    public void setCentral(BluetoothCentralManager central) {
        this.central = central;
    }

    public BluetoothGattCharacteristic getReadCharacteristic() {
        return this.readCharacteristic;
    }

    public void setReadCharacteristic(BluetoothGattCharacteristic readCharacteristic) {
        this.readCharacteristic = readCharacteristic;
    }

    public BluetoothGattCharacteristic getWriteCharacteristic() {
        return this.writeCharacteristic;
    }

    public void setWriteCharacteristic(BluetoothGattCharacteristic writeCharacteristic) {
        this.writeCharacteristic = writeCharacteristic;
    }

    public BluetoothGattCharacteristic getNotifyCharacteristic() {
        return this.notifyCharacteristic;
    }

    public void setNotifyCharacteristic(BluetoothGattCharacteristic notifyCharacteristic) {
        this.notifyCharacteristic = notifyCharacteristic;
    }

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        return false;
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    @Override
    public boolean open(String param) {
        if (param != null) {
            this.initParam = param;
        }
        this.central.connectPeripheral(this.mPeripheral, this.peripheralCallback);
        return false;
    }

    @Override
    public void open() {
        this.central.connectPeripheral(this.mPeripheral, this.peripheralCallback);
    }

    @Override
    public void autoBleOpen() {
        this.central.autoConnectPeripheral(this.mPeripheral, this.peripheralCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.keepReceived = false;
        this.writeCharacteristic = null;
        this.notifyCharacteristic = null;
        this.readCharacteristic = null;
        if (this.mPeripheral != null) {
            this.mPeripheral.cancelConnection();
        }
        Object object = this.lockRingBuffer;
        synchronized (object) {
            this.lockRingBuffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] bytes) {
        Class<BleDevice> clazz = BleDevice.class;
        synchronized (BleDevice.class) {
            try {
                if (this.writeCharacteristic != null && this.mPeripheral != null) {
                    int currentMtu = this.mPeripheral.getCurrentMtu() - 3;
                    int size = bytes.length / currentMtu;
                    if (bytes.length % currentMtu != 0) {
                        ++size;
                    }
                    if (size == 1) {
                        this.mPeripheral.writeCharacteristic(this.writeCharacteristic, bytes, this.writeCharacteristic.getWriteType() == 2 ? WriteType.WITH_RESPONSE : WriteType.WITHOUT_RESPONSE);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    for (int i = 0; i < size; ++i) {
                        byte[] newBuffer = Arrays.copyOfRange(bytes, i * currentMtu, currentMtu + i * currentMtu);
                        this.mPeripheral.writeCharacteristic(this.writeCharacteristic, newBuffer, this.writeCharacteristic.getWriteType() == 2 ? WriteType.WITH_RESPONSE : WriteType.WITHOUT_RESPONSE);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
    }

    @Override
    public void send(Message msg) {
        try {
            msg.pack();
            this.send(msg.toBytes(this.isRs485));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            @Override
            public void run() {
                while (BleDevice.this.keepReceived) {
                    try {
                        if (BleDevice.this.mPeripheral != null && BleDevice.this.readCharacteristic != null) {
                            boolean b = BleDevice.this.mPeripheral.readCharacteristic(BleDevice.this.readCharacteristic);
                            if (b) continue;
                            Thread.sleep(50L);
                            continue;
                        }
                        Thread.sleep(50L);
                    }
                    catch (Exception ex) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }
}

