/*
 * Decompiled with CFR 0.152.
 */
package com.android.usbserial.util;

import java.security.InvalidParameterException;

public class HexDump {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String dumpHexString(byte[] array) {
        return HexDump.dumpHexString(array, 0, array.length);
    }

    public static String dumpHexString(byte[] array, int offset, int length) {
        int i;
        StringBuilder result = new StringBuilder();
        byte[] line = new byte[8];
        int lineIndex = 0;
        for (i = offset; i < offset + length; ++i) {
            if (lineIndex == line.length) {
                for (int j = 0; j < line.length; ++j) {
                    if (line[j] > 32 && line[j] < 126) {
                        result.append(new String(line, j, 1));
                        continue;
                    }
                    result.append(".");
                }
                result.append("\n");
                lineIndex = 0;
            }
            byte b = array[i];
            result.append(HEX_DIGITS[b >>> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
            result.append(" ");
            line[lineIndex++] = b;
        }
        for (i = 0; i < line.length - lineIndex; ++i) {
            result.append("   ");
        }
        for (i = 0; i < lineIndex; ++i) {
            if (line[i] > 32 && line[i] < 126) {
                result.append(new String(line, i, 1));
                continue;
            }
            result.append(".");
        }
        return result.toString();
    }

    public static String toHexString(byte b) {
        return HexDump.toHexString(HexDump.toByteArray(b));
    }

    public static String toHexString(byte[] array) {
        return HexDump.toHexString(array, 0, array.length);
    }

    public static String toHexString(byte[] array, int offset, int length) {
        char[] buf = new char[length > 0 ? length * 3 - 1 : 0];
        int bufIndex = 0;
        for (int i = offset; i < offset + length; ++i) {
            if (i > offset) {
                buf[bufIndex++] = 32;
            }
            byte b = array[i];
            buf[bufIndex++] = HEX_DIGITS[b >>> 4 & 0xF];
            buf[bufIndex++] = HEX_DIGITS[b & 0xF];
        }
        return new String(buf);
    }

    public static String toHexString(int i) {
        return HexDump.toHexString(HexDump.toByteArray(i));
    }

    public static String toHexString(short i) {
        return HexDump.toHexString(HexDump.toByteArray(i));
    }

    public static byte[] toByteArray(byte b) {
        byte[] array = new byte[]{b};
        return array;
    }

    public static byte[] toByteArray(int i) {
        byte[] array = new byte[4];
        array[3] = (byte)(i & 0xFF);
        array[2] = (byte)(i >> 8 & 0xFF);
        array[1] = (byte)(i >> 16 & 0xFF);
        array[0] = (byte)(i >> 24 & 0xFF);
        return array;
    }

    public static byte[] toByteArray(short i) {
        byte[] array = new byte[2];
        array[1] = (byte)(i & 0xFF);
        array[0] = (byte)(i >> 8 & 0xFF);
        return array;
    }

    private static int toByte(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new InvalidParameterException("Invalid hex char '" + c + "'");
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int length = hexString.length();
        byte[] buffer = new byte[(length + 1) / 3];
        for (int i = 0; i < length; i += 3) {
            buffer[i / 3] = (byte)(HexDump.toByte(hexString.charAt(i)) << 4 | HexDump.toByte(hexString.charAt(i + 1)));
        }
        return buffer;
    }
}

