/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.GLog;
import com.gg.reader.api.utils.ThreadPoolUtils;
import com.gxwl.device.reader.dal.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class AndroidSerialClient
extends CommunicationInterface {
    private boolean isOpen = false;
    private int iBaudRate;
    private final int iDelay = 10;
    private InputStream mInputStream;
    private OutputStream mOutputStream;
    private SerialPort mSerialPort;
    private String sPort = "/dev/ttyS0";

    public AndroidSerialClient() {
    }

    public AndroidSerialClient(String paramString, int paramInt) {
        this.sPort = paramString;
        this.iBaudRate = paramInt;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] paramArrayOfByte) {
        Class<AndroidSerialClient> clazz = AndroidSerialClient.class;
        synchronized (AndroidSerialClient.class) {
            try {
                this.mOutputStream.write(paramArrayOfByte);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message msg) {
        Class<AndroidSerialClient> clazz = AndroidSerialClient.class;
        synchronized (AndroidSerialClient.class) {
            try {
                if (this.isRs485) {
                    msg.msgType.mt_13 = "1";
                    msg.rs485Address = this.getRs485Address();
                }
                msg.pack();
                byte[] sendData = msg.toBytes(this.isRs485);
                this.send(sendData);
            }
            catch (Exception ex) {
                GLog.e("[AndroidSerialClient]base serial send error:" + ex.getMessage());
            }
            return;
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
        this.close();
    }

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        return false;
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    @Override
    public boolean open(String param) {
        try {
            String[] arrParam = param.split(":");
            if (arrParam.length == 2) {
                this.sPort = arrParam[0];
                this.iBaudRate = Integer.parseInt(arrParam[1]);
                this.mSerialPort = new SerialPort(new File(this.sPort), this.iBaudRate, 0);
                this.mOutputStream = this.mSerialPort.getOutputStream();
                this.mInputStream = this.mSerialPort.getInputStream();
                this.isOpen = true;
                this.keepReceived = true;
                if (!this.serialBlock) {
                    this.startReceive();
                } else {
                    this.startBlockReceive();
                }
                this.startProcess();
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.isOpen = false;
            this.keepReceived = false;
            if (this.mSerialPort != null) {
                this.mSerialPort.close();
                this.mInputStream = null;
                this.mOutputStream = null;
                this.mSerialPort = null;
            }
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (AndroidSerialClient.this.keepReceived) {
                    try {
                        if (AndroidSerialClient.this.mInputStream == null) break;
                        int len = AndroidSerialClient.this.mInputStream.available();
                        if (len > 0) {
                            len = AndroidSerialClient.this.mInputStream.read(AndroidSerialClient.this.rcvBuff, 0, AndroidSerialClient.this.rcvBuff.length);
                            Object object = AndroidSerialClient.this.lockRingBuffer;
                            synchronized (object) {
                                while (len + AndroidSerialClient.this.ringBuffer.getDataCount() > 0x100000) {
                                    AndroidSerialClient.this.lockRingBuffer.wait(10000L);
                                }
                                AndroidSerialClient.this.ringBuffer.WriteBuffer(AndroidSerialClient.this.rcvBuff, 0, len);
                                AndroidSerialClient.this.lockRingBuffer.notify();
                                continue;
                            }
                        }
                        Thread.sleep(10L);
                    }
                    catch (Exception ex) {
                        GLog.e("[AndroidSerialClient]startReceive error." + ex.getMessage());
                    }
                }
            }
        });
    }

    public void startBlockReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (AndroidSerialClient.this.keepReceived) {
                    try {
                        if (AndroidSerialClient.this.mInputStream == null) break;
                        int len = AndroidSerialClient.this.mInputStream.read(AndroidSerialClient.this.rcvBuff, 0, AndroidSerialClient.this.rcvBuff.length);
                        if (len > 0) {
                            Object object = AndroidSerialClient.this.lockRingBuffer;
                            synchronized (object) {
                                while (len + AndroidSerialClient.this.ringBuffer.getDataCount() > 0x100000) {
                                    AndroidSerialClient.this.lockRingBuffer.wait(10000L);
                                }
                                AndroidSerialClient.this.ringBuffer.WriteBuffer(AndroidSerialClient.this.rcvBuff, 0, len);
                                AndroidSerialClient.this.lockRingBuffer.notify();
                                continue;
                            }
                        }
                        Thread.sleep(10L);
                    }
                    catch (Exception ex) {
                        GLog.e("[AndroidSerialClient]startReceive error." + ex.getMessage());
                    }
                }
            }
        });
    }
}

