/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.gg.reader.api.dal.communication.BluetoothHandler;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgAppGetReaderInfo;
import com.gg.reader.api.utils.StringUtils;
import com.gg.reader.api.utils.ThreadPoolUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class BluetoothClient
extends CommunicationInterface {
    private String TAG = BluetoothClient.class.getName();
    private static final UUID SPP_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private BluetoothSocket socket;
    private BluetoothDevice device;
    private InputStream inputStream;
    private OutputStream outputStream;
    private BluetoothAdapter bluetoothAdapter;
    public BluetoothHandler bluetoothHandler;
    private Date lastUrgentData = null;
    private int count = 1;
    private int reconnection = 10;
    private int tempReConCount = 0;
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            Set bondDevice = BluetoothClient.this.bluetoothAdapter.getBondedDevices();
            if (bondDevice.size() > 0) {
                for (BluetoothDevice info : bondDevice) {
                    if (BluetoothClient.this.bluetoothHandler == null) continue;
                    BluetoothClient.this.bluetoothHandler.dispense(info);
                }
            }
            if ("android.bluetooth.device.action.FOUND".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (device.getBondState() != 12 && BluetoothClient.this.bluetoothHandler != null) {
                    if (!StringUtils.isNullOfEmpty(device.getName())) {
                        BluetoothClient.this.bluetoothHandler.dispense(device);
                    } else {
                        BluetoothClient.this.bluetoothHandler.dispense(device);
                    }
                }
            } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                if (BluetoothClient.this.bluetoothHandler != null) {
                    BluetoothClient.this.bluetoothHandler.finishDiscover();
                }
            } else if ("android.bluetooth.adapter.action.DISCOVERY_STARTED".equals(action) && BluetoothClient.this.bluetoothHandler != null) {
                BluetoothClient.this.bluetoothHandler.startDiscover();
            }
        }
    };

    public BluetoothClient() {
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public BluetoothAdapter getAdapter() {
        return this.bluetoothAdapter;
    }

    @Override
    public boolean open(String s, int i) {
        try {
            if (this.socket != null || StringUtils.isNullOfEmpty(s)) {
                return false;
            }
            if (this.bluetoothAdapter.isDiscovering()) {
                this.bluetoothAdapter.cancelDiscovery();
            }
            this.device = this.bluetoothAdapter.getRemoteDevice(s);
            this.socket = i == 0 ? this.device.createInsecureRfcommSocketToServiceRecord(SPP_UUID) : this.device.createRfcommSocketToServiceRecord(SPP_UUID);
            this.socket.connect();
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            this.keepReceived = true;
            this.lastUrgentData = new Date();
            this.startReceive();
            this.startProcess();
            return true;
        }
        catch (Exception ex) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                Log.e((String)BluetoothClient.class.getName(), (String)e.getMessage());
            }
            return false;
        }
    }

    @Override
    public boolean open(Socket socket) {
        return false;
    }

    @Override
    public boolean open(String s, int i, int i1) {
        return false;
    }

    @Override
    public boolean open(String param) {
        try {
            if (this.socket != null || StringUtils.isNullOfEmpty(param)) {
                return false;
            }
            if (this.bluetoothAdapter.isDiscovering()) {
                this.bluetoothAdapter.cancelDiscovery();
            }
            this.device = this.bluetoothAdapter.getRemoteDevice(param);
            this.socket = this.device.createInsecureRfcommSocketToServiceRecord(SPP_UUID);
            this.socket.connect();
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            this.keepReceived = true;
            this.lastUrgentData = new Date();
            this.startReceive();
            this.startProcess();
            return true;
        }
        catch (Exception ex) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                Log.e((String)BluetoothClient.class.getName(), (String)e.getMessage());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.keepReceived = false;
            this.onDisconnected = null;
            if (null != this.socket) {
                this.socket.close();
                this.inputStream = null;
                this.outputStream = null;
            }
            this.socket = null;
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] bytes) {
        BluetoothClient bluetoothClient = this;
        synchronized (bluetoothClient) {
            try {
                if (this.outputStream != null) {
                    this.outputStream.write(bytes);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void send(Message message) {
        try {
            message.pack();
            this.send(message.toBytes(this.isRs485));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int receive(byte[] bytes) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int i) {
        return false;
    }

    @Override
    public void dispose() {
    }

    private boolean isRemoteClosed() {
        if (null == this.socket) {
            return true;
        }
        Date now = new Date();
        if (now.getTime() - this.lastUrgentData.getTime() > (long)(3000 * this.count)) {
            try {
                ++this.count;
                this.send(new MsgAppGetReaderInfo());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return now.getTime() - this.lastUrgentData.getTime() > (long)this.heartbeatTimeout;
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (BluetoothClient.this.keepReceived) {
                    try {
                        int len = BluetoothClient.this.inputStream.available();
                        if (len <= 0) {
                            Thread.sleep(10L);
                        }
                        if (len > 0) {
                            len = BluetoothClient.this.inputStream.read(BluetoothClient.this.rcvBuff, 0, BluetoothClient.this.rcvBuff.length);
                            Object object = BluetoothClient.this.lockRingBuffer;
                            synchronized (object) {
                                while (len + BluetoothClient.this.ringBuffer.getDataCount() > 0x100000) {
                                    BluetoothClient.this.lockRingBuffer.wait(10000L);
                                }
                                BluetoothClient.this.ringBuffer.WriteBuffer(BluetoothClient.this.rcvBuff, 0, len);
                                BluetoothClient.this.lockRingBuffer.notify();
                            }
                        }
                        if (!BluetoothClient.this._isSendHeartbeat) continue;
                        if (len <= 0) {
                            if (!BluetoothClient.this.isRemoteClosed()) continue;
                            throw new Exception("remote closed.");
                        }
                        BluetoothClient.this.lastUrgentData = new Date();
                        BluetoothClient.this.count = 1;
                    }
                    catch (Exception ex) {
                        try {
                            BluetoothClient.this.triggerDisconnected();
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public void scanBluetooth() {
        if (null != this.bluetoothAdapter) {
            if (!this.bluetoothAdapter.isEnabled()) {
                this.bluetoothAdapter.enable();
            } else {
                this.bluetoothAdapter.startDiscovery();
            }
        } else {
            Log.e((String)this.TAG, (String)"\u5f53\u524d\u8bbe\u5907\u6ca1\u6709\u84dd\u7259\u6a21\u5757");
        }
    }

    public void registerBluetoothScanReceiver(Context context) {
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        filter.addAction("android.bluetooth.device.action.FOUND");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        filter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        context.registerReceiver(this.receiver, filter);
    }

    public void unRegisterBluetoothScanReceiver(Context context) {
        context.unregisterReceiver(this.receiver);
    }

    public void stopScanner() {
        if (this.bluetoothAdapter != null && this.bluetoothAdapter.isDiscovering()) {
            this.bluetoothAdapter.cancelDiscovery();
        }
    }

    public void startScanner() {
        if (this.bluetoothAdapter != null && !this.bluetoothAdapter.isDiscovering()) {
            this.bluetoothAdapter.startDiscovery();
        }
    }

    public Set<BluetoothDevice> getBondDevice() {
        if (this.bluetoothAdapter != null) {
            return this.bluetoothAdapter.getBondedDevices();
        }
        return new HashSet<BluetoothDevice>();
    }

    public void setDisPlay(Context context, int time) {
        Intent displayIntent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
        displayIntent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", time);
        context.startActivity(displayIntent);
    }

    public void openBluetooth() {
        if (this.bluetoothAdapter != null && !this.bluetoothAdapter.isEnabled()) {
            this.bluetoothAdapter.enable();
        }
    }

    public void closeBluetooth() {
        if (this.bluetoothAdapter != null && this.bluetoothAdapter.isEnabled()) {
            this.bluetoothAdapter.disable();
        }
    }

    private void openBluetoothSetting(Context context) {
        Intent intent = new Intent();
        intent.setAction("android.settings.BLUETOOTH_SETTINGS");
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }
}

