/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import java.util.ArrayList;
import java.util.List;

public class LogBaseAccessInfo
extends Message {
    private String epc;
    private byte[] bEpc;
    private int pc;
    private int antId;
    private int rssi;
    private Long frequencyPoint;
    private List<OperateResult> operateList;

    public String getEpc() {
        return this.epc;
    }

    public void setEpc(String epc) {
        this.epc = epc;
    }

    public byte[] getbEpc() {
        return this.bEpc;
    }

    public void setbEpc(byte[] bEpc) {
        this.bEpc = bEpc;
    }

    public int getPc() {
        return this.pc;
    }

    public void setPc(int pc) {
        this.pc = pc;
    }

    public int getAntId() {
        return this.antId;
    }

    public void setAntId(int antId) {
        this.antId = antId;
    }

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    public Long getFrequencyPoint() {
        return this.frequencyPoint;
    }

    public void setFrequencyPoint(Long frequencyPoint) {
        this.frequencyPoint = frequencyPoint;
    }

    public List<OperateResult> getOperateList() {
        return this.operateList;
    }

    public void setOperateList(List<OperateResult> operateList) {
        this.operateList = operateList;
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            int epcLen = buffer.getIntUnsigned(16);
            this.bEpc = new byte[epcLen];
            this.bEpc = buffer.get(this.bEpc);
            if (this.bEpc.length > 0) {
                this.epc = HexUtils.bytes2HexString(this.bEpc);
            }
            this.pc = buffer.getIntUnsigned(16);
            this.antId = buffer.getIntUnsigned(8);
            int operateIndex = 3;
            block4: while (buffer.position() / 8 < this.cData.length) {
                int index = buffer.getIntUnsigned(8);
                switch (index) {
                    case 1: {
                        this.rssi = buffer.getIntUnsigned(8);
                        continue block4;
                    }
                    case 2: {
                        this.frequencyPoint = buffer.getLongUnsigned(32);
                        continue block4;
                    }
                }
                if (index != operateIndex) continue;
                int len = buffer.getIntUnsigned(16);
                if (this.operateList == null) {
                    this.operateList = new ArrayList<OperateResult>();
                }
                OperateResult operateResult = new OperateResult();
                operateResult.setResult(buffer.getIntUnsigned(8));
                if (len > 1) {
                    byte[] bytes = new byte[len - 1];
                    buffer.get(bytes);
                    operateResult.setHexReadData(HexUtils.bytes2HexString(bytes));
                }
                this.operateList.add(operateResult);
                ++operateIndex;
            }
        }
    }

    public String toString() {
        return "LogBaseAccessInfo{epc='" + this.epc + '\'' + ", pc=" + this.pc + ", antId=" + this.antId + ", rssi=" + this.rssi + ", frequencyPoint=" + this.frequencyPoint + ", operateList=" + this.operateList + '}';
    }

    public static class OperateResult {
        private int result;
        private String hexReadData;

        public int getResult() {
            return this.result;
        }

        public void setResult(int result) {
            this.result = result;
        }

        public String getHexReadData() {
            return this.hexReadData;
        }

        public void setHexReadData(String hexReadData) {
            this.hexReadData = hexReadData;
        }

        public String toString() {
            return "OperateResult{result=" + this.result + ", hexReadData='" + this.hexReadData + '\'' + '}';
        }
    }
}

