/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.DateTimeUtils;
import com.gg.reader.api.utils.HexUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.TimeZone;

public class LogBaseEpcInfo
extends Message {
    private String epc;
    private byte[] bEpc;
    private int pc;
    private int antId;
    private int rssi;
    private int result;
    private String tid;
    private byte[] bTid;
    private String userdata;
    private byte[] bUser;
    private String reserved;
    private byte[] bRes;
    private int childAntId;
    private String strUtc;
    private Long frequencyPoint;
    private int phase;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String epcData;
    private byte[] bEpcData;
    private int ctesiusLtu27;
    private int ctesiusLtu31;
    private String readerSerialNumber;
    private Long replySerialNumber;
    private int kunYue;
    private int rssidBm;
    private int crc;
    private String EPC_2V2_challenge;
    private String EPC_2V2_tag_response;
    private int cykeoRule;
    private String quanray_temp;
    private String quanray_rawData;

    public String getEpc() {
        return this.epc;
    }

    public void setEpc(String epc) {
        this.epc = epc;
    }

    public byte[] getbEpc() {
        return this.bEpc;
    }

    public void setbEpc(byte[] bEpc) {
        this.bEpc = bEpc;
    }

    public int getPc() {
        return this.pc;
    }

    public void setPc(int pc) {
        this.pc = pc;
    }

    public int getAntId() {
        return this.antId;
    }

    public void setAntId(int antId) {
        this.antId = antId;
    }

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getTid() {
        return this.tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public byte[] getbTid() {
        return this.bTid;
    }

    public void setbTid(byte[] bTid) {
        this.bTid = bTid;
    }

    public String getUserdata() {
        return this.userdata;
    }

    public void setUserdata(String userdata) {
        this.userdata = userdata;
    }

    public byte[] getbUser() {
        return this.bUser;
    }

    public void setbUser(byte[] bUser) {
        this.bUser = bUser;
    }

    public String getReserved() {
        return this.reserved;
    }

    public void setReserved(String reserved) {
        this.reserved = reserved;
    }

    public byte[] getbRes() {
        return this.bRes;
    }

    public void setbRes(byte[] bRes) {
        this.bRes = bRes;
    }

    public int getChildAntId() {
        return this.childAntId;
    }

    public void setChildAntId(int childAntId) {
        this.childAntId = childAntId;
    }

    public String getStrUtc() {
        return this.strUtc;
    }

    public void setStrUtc(String strUtc) {
        this.strUtc = strUtc;
    }

    public Long getFrequencyPoint() {
        return this.frequencyPoint;
    }

    public void setFrequencyPoint(Long frequencyPoint) {
        this.frequencyPoint = frequencyPoint;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public String getEpcData() {
        return this.epcData;
    }

    public void setEpcData(String epcData) {
        this.epcData = epcData;
    }

    public byte[] getbEpcData() {
        return this.bEpcData;
    }

    public void setbEpcData(byte[] bEpcData) {
        this.bEpcData = bEpcData;
    }

    public int getCtesiusLtu27() {
        return this.ctesiusLtu27;
    }

    public void setCtesiusLtu27(int ctesiusLtu27) {
        this.ctesiusLtu27 = ctesiusLtu27;
    }

    public int getCtesiusLtu31() {
        return this.ctesiusLtu31;
    }

    public void setCtesiusLtu31(int ctesiusLtu31) {
        this.ctesiusLtu31 = ctesiusLtu31;
    }

    public String getReaderSerialNumber() {
        return this.readerSerialNumber;
    }

    public void setReaderSerialNumber(String readerSerialNumber) {
        this.readerSerialNumber = readerSerialNumber;
    }

    public Long getReplySerialNumber() {
        return this.replySerialNumber;
    }

    public void setReplySerialNumber(Long replySerialNumber) {
        this.replySerialNumber = replySerialNumber;
    }

    public int getRssidBm() {
        return this.rssidBm;
    }

    public void setRssidBm(int rssidBm) {
        this.rssidBm = rssidBm;
    }

    public int getKunYue() {
        return this.kunYue;
    }

    public void setKunYue(int kunYue) {
        this.kunYue = kunYue;
    }

    public int getCrc() {
        return this.crc;
    }

    public void setCrc(int crc) {
        this.crc = crc;
    }

    public String getEPC_2V2_challenge() {
        return this.EPC_2V2_challenge;
    }

    public void setEPC_2V2_challenge(String EPC_2V2_challenge) {
        this.EPC_2V2_challenge = EPC_2V2_challenge;
    }

    public String getEPC_2V2_tag_response() {
        return this.EPC_2V2_tag_response;
    }

    public void setEPC_2V2_tag_response(String EPC_2V2_tag_response) {
        this.EPC_2V2_tag_response = EPC_2V2_tag_response;
    }

    public int getCykeoRule() {
        return this.cykeoRule;
    }

    public void setCykeoRule(int cykeoRule) {
        this.cykeoRule = cykeoRule;
    }

    public String getQuanray_temp() {
        return this.quanray_temp;
    }

    public void setQuanray_temp(String quanray_temp) {
        this.quanray_temp = quanray_temp;
    }

    public String getQuanray_rawData() {
        return this.quanray_rawData;
    }

    public void setQuanray_rawData(String quanray_rawData) {
        this.quanray_rawData = quanray_rawData;
    }

    @Override
    public void pack() {
        super.pack();
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            int epcLen = buffer.getIntUnsigned(16);
            this.bEpc = new byte[epcLen];
            this.bEpc = buffer.get(this.bEpc);
            if (this.bEpc.length > 0) {
                this.epc = HexUtils.bytes2HexString(this.bEpc);
            }
            this.pc = buffer.getIntUnsigned(16);
            this.antId = buffer.getIntUnsigned(8);
            block37: while (buffer.position() / 8 < this.cData.length) {
                int index = buffer.getIntUnsigned(8);
                switch (index) {
                    case 1: {
                        this.rssi = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 2: {
                        this.result = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 3: {
                        try {
                            int tidLen = buffer.getIntUnsigned(16);
                            if (tidLen <= 0) continue block37;
                            this.bTid = new byte[tidLen];
                            this.bTid = buffer.get(this.bTid);
                            this.tid = HexUtils.bytes2HexString(this.bTid);
                        }
                        catch (Exception tidLen) {}
                        break;
                    }
                    case 4: {
                        try {
                            int userLen = buffer.getIntUnsigned(16);
                            if (userLen <= 0) continue block37;
                            this.bUser = new byte[userLen];
                            this.bUser = buffer.get(this.bUser);
                            this.userdata = HexUtils.bytes2HexString(this.bUser);
                        }
                        catch (Exception userLen) {}
                        break;
                    }
                    case 5: {
                        try {
                            int resLen = buffer.getIntUnsigned(16);
                            if (resLen <= 0) continue block37;
                            this.bRes = new byte[resLen];
                            this.bRes = buffer.get(this.bRes);
                            this.reserved = HexUtils.bytes2HexString(this.bRes);
                        }
                        catch (Exception resLen) {}
                        break;
                    }
                    case 6: {
                        this.childAntId = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 7: {
                        long utcSecond = buffer.getLong(32) * 1000L;
                        long utcMicrosecond = buffer.getLong(32) / 1000L;
                        long ms = utcSecond + utcMicrosecond;
                        this.strUtc = this.dateFormat.format(DateTimeUtils.fromUtcToTimeZone(ms, TimeZone.getDefault()));
                        break;
                    }
                    case 8: {
                        this.frequencyPoint = buffer.getLongUnsigned(32);
                        break;
                    }
                    case 9: {
                        this.phase = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 10: {
                        try {
                            int epcDataLen = buffer.getIntUnsigned(16);
                            if (epcDataLen <= 0) continue block37;
                            this.bEpcData = new byte[epcDataLen];
                            this.bEpcData = buffer.get(this.bEpcData);
                            this.epcData = HexUtils.bytes2HexString(this.bEpcData);
                        }
                        catch (Exception epcDataLen) {}
                        break;
                    }
                    case 11: {
                        try {
                            int challengeLen = buffer.getIntUnsigned(16);
                            if (challengeLen <= 0) continue block37;
                            byte[] challenge = new byte[challengeLen];
                            buffer.get(challenge);
                            this.EPC_2V2_challenge = HexUtils.bytes2HexString(challenge);
                        }
                        catch (Exception challengeLen) {}
                        break;
                    }
                    case 12: {
                        try {
                            int tag_response_len = buffer.getIntUnsigned(16);
                            if (tag_response_len <= 0) continue block37;
                            byte[] tag_response = new byte[tag_response_len];
                            buffer.get(tag_response);
                            this.EPC_2V2_tag_response = HexUtils.bytes2HexString(tag_response);
                        }
                        catch (Exception tag_response_len) {}
                        break;
                    }
                    case 17: {
                        this.ctesiusLtu27 = buffer.getIntUnsigned(16);
                        break;
                    }
                    case 18: {
                        this.ctesiusLtu31 = buffer.getInt(16);
                        break;
                    }
                    case 19: {
                        this.kunYue = buffer.getIntUnsigned(16);
                        break;
                    }
                    case 20: {
                        this.rssidBm = buffer.getInt(16);
                        break;
                    }
                    case 21: {
                        this.crc = buffer.getIntUnsigned(16);
                        break;
                    }
                    case 22: {
                        this.quanray_temp = String.valueOf(buffer.getInt(16));
                        byte[] rawBytes = new byte[6];
                        this.quanray_rawData = HexUtils.bytes2HexString(buffer.get(rawBytes));
                        break;
                    }
                    case 32: {
                        try {
                            int snLen = buffer.getIntUnsigned(16);
                            if (snLen <= 0) continue block37;
                            this.readerSerialNumber = new String(buffer.get(new byte[snLen]), "ASCII");
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 34: {
                        this.replySerialNumber = buffer.getLongUnsigned(32);
                        break;
                    }
                    case 36: {
                        this.cykeoRule = buffer.getIntUnsigned(8);
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        return "LogBaseEpcInfo{epc='" + this.epc + '\'' + ", bEpc=" + Arrays.toString(this.bEpc) + ", pc=" + this.pc + ", antId=" + this.antId + ", rssi=" + this.rssi + ", result=" + this.result + ", tid='" + this.tid + '\'' + ", bTid=" + Arrays.toString(this.bTid) + ", userdata='" + this.userdata + '\'' + ", bUser=" + Arrays.toString(this.bUser) + ", reserved='" + this.reserved + '\'' + ", bRes=" + Arrays.toString(this.bRes) + ", childAntId=" + this.childAntId + ", strUtc='" + this.strUtc + '\'' + ", frequencyPoint=" + this.frequencyPoint + ", phase=" + this.phase + ", dateFormat=" + this.dateFormat + ", epcData='" + this.epcData + '\'' + ", bEpcData=" + Arrays.toString(this.bEpcData) + ", ctesiusLtu27=" + this.ctesiusLtu27 + ", ctesiusLtu31=" + this.ctesiusLtu31 + ", readerSerialNumber='" + this.readerSerialNumber + '\'' + ", replySerialNumber=" + this.replySerialNumber + ", kunYue=" + this.kunYue + ", rssidBm=" + this.rssidBm + ", crc=" + this.crc + ", EPC_2V2_challenge='" + this.EPC_2V2_challenge + '\'' + ", EPC_2V2_tag_response='" + this.EPC_2V2_tag_response + '\'' + '}';
    }

    public String toHexString() {
        return "HexString{" + HexUtils.bytes2HexString(this.cData) + '}';
    }
}

