/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.ParamEncipheredData;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;

public class LogBaseGbSafeParam
extends Message {
    private int antId;
    private String safeParam;
    private String tagIdentifier;
    private String random;
    private String token2;
    private ParamEncipheredData encipheredData;
    private String readerSerialNumber;
    private String tidAndRT32;

    public int getAntId() {
        return this.antId;
    }

    public void setAntId(int antId) {
        this.antId = antId;
    }

    public String getSafeParam() {
        return this.safeParam;
    }

    public void setSafeParam(String safeParam) {
        this.safeParam = safeParam;
    }

    public String getTagIdentifier() {
        return this.tagIdentifier;
    }

    public void setTagIdentifier(String tagIdentifier) {
        this.tagIdentifier = tagIdentifier;
    }

    public String getRandom() {
        return this.random;
    }

    public void setRandom(String random) {
        this.random = random;
    }

    public String getToken2() {
        return this.token2;
    }

    public void setToken2(String token2) {
        this.token2 = token2;
    }

    public ParamEncipheredData getEncipheredData() {
        return this.encipheredData;
    }

    public void setEncipheredData(ParamEncipheredData encipheredData) {
        this.encipheredData = encipheredData;
    }

    public String getReaderSerialNumber() {
        return this.readerSerialNumber;
    }

    public void setReaderSerialNumber(String readerSerialNumber) {
        this.readerSerialNumber = readerSerialNumber;
    }

    public String getTidAndRT32() {
        return this.tidAndRT32;
    }

    public void setTidAndRT32(String tidAndRT32) {
        this.tidAndRT32 = tidAndRT32;
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.antId = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < this.cData.length) {
                int index = buffer.getIntUnsigned(8);
                switch (index) {
                    case 1: {
                        byte[] spBytes = new byte[6];
                        buffer.get(spBytes);
                        this.safeParam = HexUtils.bytes2HexString(spBytes);
                        break;
                    }
                    case 2: {
                        byte[] tagIBytes = new byte[8];
                        buffer.get(tagIBytes);
                        this.tagIdentifier = HexUtils.bytes2HexString(tagIBytes);
                        break;
                    }
                    case 3: {
                        byte[] randomBytes = new byte[4];
                        buffer.get(randomBytes);
                        this.random = HexUtils.bytes2HexString(randomBytes);
                        break;
                    }
                    case 4: {
                        byte[] token2Bytes = new byte[8];
                        buffer.get(token2Bytes);
                        this.token2 = HexUtils.bytes2HexString(token2Bytes);
                        break;
                    }
                    case 5: {
                        int length = buffer.getIntUnsigned(16);
                        byte[] bytes = new byte[length];
                        if (length <= 0) break;
                        buffer.get(bytes);
                        this.encipheredData = new ParamEncipheredData(bytes);
                        break;
                    }
                    case 6: {
                        byte[] tidAndRTBytes = new byte[16];
                        buffer.get(tidAndRTBytes);
                        this.tidAndRT32 = HexUtils.bytes2HexString(tidAndRTBytes);
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        return "LogBaseGbSafeParam{antId=" + this.antId + ", safeParam='" + this.safeParam + '\'' + ", tagIdentifier='" + this.tagIdentifier + '\'' + ", random='" + this.random + '\'' + ", token2='" + this.token2 + '\'' + ", encipheredData=" + this.encipheredData + ", readerSerialNumber='" + this.readerSerialNumber + '\'' + ", tidAndRT32='" + this.tidAndRT32 + '\'' + '}';
    }
}

