/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Arrays;

public class MsgAppGetGpiTrigger
extends Message {
    private int gpiPort;
    private int triggerStart;
    private byte[] triggerCommand;
    private String hexTriggerCommand;
    private int triggerOver;
    private int overDelayTime = Integer.MAX_VALUE;
    private int levelUploadSwitch = Integer.MAX_VALUE;
    private int antiShakeTime = Integer.MAX_VALUE;

    public MsgAppGetGpiTrigger() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)12;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetGpiTrigger(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.triggerStart = buffer.getIntUnsigned(8);
            int cmdLen = buffer.getIntUnsigned(16);
            if (cmdLen > 0) {
                byte[] triggerCommandData = new byte[cmdLen];
                this.triggerCommand = buffer.get(triggerCommandData);
                this.hexTriggerCommand = HexUtils.bytes2HexString(this.triggerCommand);
            }
            this.triggerOver = buffer.getIntUnsigned(8);
            this.overDelayTime = buffer.getIntUnsigned(16);
            this.levelUploadSwitch = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getGpiPort() {
        return this.gpiPort;
    }

    public void setGpiPort(int gpiPort) {
        this.gpiPort = gpiPort;
    }

    public int getTriggerStart() {
        return this.triggerStart;
    }

    public void setTriggerStart(int triggerStart) {
        this.triggerStart = triggerStart;
    }

    public byte[] getTriggerCommand() {
        return this.triggerCommand;
    }

    public void setTriggerCommand(byte[] triggerCommand) {
        this.triggerCommand = triggerCommand;
    }

    public String getHexTriggerCommand() {
        return this.hexTriggerCommand;
    }

    public void setHexTriggerCommand(String hexTriggerCommand) {
        if (!StringUtils.isNullOfEmpty(hexTriggerCommand)) {
            this.hexTriggerCommand = hexTriggerCommand;
            this.triggerCommand = HexUtils.hexString2Bytes(this.hexTriggerCommand);
        }
    }

    public int getTriggerOver() {
        return this.triggerOver;
    }

    public void setTriggerOver(int triggerOver) {
        this.triggerOver = triggerOver;
    }

    public int getOverDelayTime() {
        return this.overDelayTime;
    }

    public void setOverDelayTime(int overDelayTime) {
        this.overDelayTime = overDelayTime;
    }

    public int getLevelUploadSwitch() {
        return this.levelUploadSwitch;
    }

    public void setLevelUploadSwitch(int levelUploadSwitch) {
        this.levelUploadSwitch = levelUploadSwitch;
    }

    public int getAntiShakeTime() {
        return this.antiShakeTime;
    }

    public void setAntiShakeTime(int antiShakeTime) {
        this.antiShakeTime = antiShakeTime;
    }

    @Override
    public void pack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.gpiPort, 8);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.triggerStart, 8);
            if (null != this.triggerCommand && this.triggerCommand.length >= 0) {
                buffer.putInt(this.triggerCommand.length, 16);
                buffer.put(this.triggerCommand);
            } else {
                buffer.putInt(0, 16);
            }
            buffer.putLong(this.triggerOver, 8);
            if (Integer.MAX_VALUE != this.overDelayTime) {
                buffer.put(this.overDelayTime, 16);
            }
            if (Integer.MAX_VALUE != this.levelUploadSwitch) {
                buffer.putLong(this.levelUploadSwitch, 8);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.triggerStart = buffer.getIntUnsigned(8);
            int cmdLen = buffer.getIntUnsigned(16);
            if (cmdLen > 0) {
                byte[] triggerCommandData = new byte[cmdLen];
                this.triggerCommand = buffer.get(triggerCommandData);
                this.hexTriggerCommand = HexUtils.bytes2HexString(this.triggerCommand);
            }
            this.triggerOver = buffer.getIntUnsigned(8);
            this.overDelayTime = buffer.getIntUnsigned(16);
            this.levelUploadSwitch = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < this.cData.length) {
                int pid = buffer.getIntUnsigned(8);
                switch (pid) {
                    case 3: {
                        this.antiShakeTime = buffer.getIntUnsigned(16);
                    }
                }
            }
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetGpiTrigger{gpiPort=" + this.gpiPort + ", triggerStart=" + this.triggerStart + ", triggerCommand=" + Arrays.toString(this.triggerCommand) + ", hexTriggerCommand='" + this.hexTriggerCommand + '\'' + ", triggerOver=" + this.triggerOver + ", overDelayTime=" + this.overDelayTime + ", levelUploadSwitch=" + this.levelUploadSwitch + '}';
    }
}

