/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.dal.GClient;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgAppGetLxAirPortParam
extends Message {
    private int voltage;
    private int electricQuantity;
    private int chargeState;

    public MsgAppGetLxAirPortParam() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)87;
            GClient client = new GClient();
            MsgAppGetLxAirPortParam msg = new MsgAppGetLxAirPortParam();
            client.sendSynMsg(msg);
            if (msg.getRtCode() == 0) {
                System.err.println(msg.toString());
            }
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetLxAirPortParam(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.voltage = buffer.getIntUnsigned(16);
            this.electricQuantity = buffer.getIntUnsigned(8);
            this.chargeState = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getVoltage() {
        return this.voltage;
    }

    public void setVoltage(int voltage) {
        this.voltage = voltage;
    }

    public int getElectricQuantity() {
        return this.electricQuantity;
    }

    public void setElectricQuantity(int electricQuantity) {
        this.electricQuantity = electricQuantity;
    }

    public int getChargeState() {
        return this.chargeState;
    }

    public void setChargeState(int chargeState) {
        this.chargeState = chargeState;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putInt(this.voltage, 16);
            buffer.putInt(this.electricQuantity, 8);
            buffer.putInt(this.chargeState, 8);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.voltage = buffer.getIntUnsigned(16);
            this.electricQuantity = buffer.getIntUnsigned(8);
            this.chargeState = buffer.getIntUnsigned(8);
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetLxAirPortParam{voltage=" + this.voltage + ", electricQuantity=" + this.electricQuantity + ", chargeState=" + this.chargeState + '}';
    }
}

