/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgBaseEBookTransfer
extends Message {
    private Long packetNumber;
    private byte[] packetContent;

    public MsgBaseEBookTransfer() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)-94;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseEBookTransfer(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.packetNumber = buffer.getLongUnsigned(32);
            int len = buffer.getIntUnsigned(16);
            byte[] packetData = new byte[len];
            if (len > 0) {
                this.packetContent = buffer.get(packetData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getPacketNumber() {
        return this.packetNumber;
    }

    public void setPacketNumber(Long packetNumber) {
        this.packetNumber = packetNumber;
    }

    public byte[] getPacketContent() {
        return this.packetContent;
    }

    public void setPacketContent(byte[] packetContent) {
        this.packetContent = packetContent;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.put(this.packetNumber, 32);
        if (null != this.packetContent && this.packetContent.length > 0) {
            buffer.putInt(this.packetContent.length, 16);
            buffer.put(this.packetContent, 8);
        } else {
            buffer.putInt(0, 16);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Fail.");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.packetNumber = buffer.getLong(32);
            byte code = buffer.getByteUnsigned(8);
            this.setRtCode(code);
            if (dicErrorMsg.containsKey(code)) {
                this.setRtMsg((String)dicErrorMsg.get(code));
            }
        }
    }
}

