/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgBaseInventoryTL
extends Message {
    private Long antennaEnable;
    private int inventoryMode;
    private int tagType;
    private int timeout = Integer.MAX_VALUE;

    public MsgBaseInventoryTL() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)112;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseInventoryTL(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.inventoryMode = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 23: {
                        this.timeout = buffer.getIntUnsigned(32);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public int getTagType() {
        return this.tagType;
    }

    public void setTagType(int tagType) {
        this.tagType = tagType;
        this.msgType.msgId = (byte)this.tagType;
    }

    public int getInventoryMode() {
        return this.inventoryMode;
    }

    public void setInventoryMode(int inventoryMode) {
        this.inventoryMode = inventoryMode;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void pack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.antennaEnable, 32);
            buffer.putLong(this.inventoryMode, 8);
            if (this.timeout != Integer.MAX_VALUE) {
                buffer.putInt(23, 8);
                buffer.putInt(this.timeout, 32);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter error.");
                this.put((byte)2, "Filter parameter error.");
                this.put((byte)3, "TID parameter error.");
                this.put((byte)4, "User parameter error.");
                this.put((byte)5, "Reserve parameter error.");
                this.put((byte)6, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }

    public String toString() {
        return "MsgBaseInventoryGbT{antennaEnable=" + this.antennaEnable + ", inventoryMode=" + this.inventoryMode + ", timeout=" + this.timeout + '}';
    }
}

