/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class MsgBaseSetFrequency
extends Message {
    private Boolean automatically;
    private List<Integer> listFreqCursor;
    private int powerDownSave = Integer.MAX_VALUE;
    private int mode = Integer.MAX_VALUE;

    public MsgBaseSetFrequency() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)5;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseSetFrequency(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.automatically = buffer.getIntUnsigned(8) == 1;
            block6: while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        if (null == this.listFreqCursor) {
                            this.listFreqCursor = new ArrayList<Integer>();
                        }
                        int len = buffer.getIntUnsigned(16);
                        for (int i = 0; i < len; ++i) {
                            this.listFreqCursor.add(buffer.getIntUnsigned(8));
                        }
                        continue block6;
                    }
                    case 2: {
                        this.powerDownSave = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Boolean getAutomatically() {
        return this.automatically;
    }

    public void setAutomatically(Boolean automatically) {
        this.automatically = automatically;
    }

    public List<Integer> getListFreqCursor() {
        return this.listFreqCursor;
    }

    public void setListFreqCursor(List<Integer> listFreqCursor) {
        this.listFreqCursor = listFreqCursor;
    }

    public int getPowerDownSave() {
        return this.powerDownSave;
    }

    public void setPowerDownSave(int powerDownSave) {
        this.powerDownSave = powerDownSave;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(this.automatically != false ? 1 : 0, 8);
        if (null != this.listFreqCursor && this.listFreqCursor.size() > 0) {
            buffer.putInt(1, 8);
            buffer.putInt(this.listFreqCursor.size(), 16);
            for (int b : this.listFreqCursor) {
                buffer.putLong(b, 8);
            }
        }
        if (Integer.MAX_VALUE != this.powerDownSave) {
            buffer.putInt(2, 8);
            buffer.putInt(this.powerDownSave, 8);
        }
        if (Integer.MAX_VALUE != this.mode) {
            buffer.putInt(254, 8);
            buffer.putInt(this.mode, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "The channel number is not in the current frequency band.");
                this.put((byte)2, "Invalid frequency points.");
                this.put((byte)3, "Other error.");
                this.put((byte)4, "Save failure.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

