/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Parameter;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;

public class ParamAccessOperate
extends Parameter {
    private int type;
    private int interval;
    private Parameter parameter;
    private int result;
    private String hexReadData;

    public ParamAccessOperate(int type, int interval, Parameter parameter) {
        this.type = type;
        this.interval = interval;
        this.parameter = parameter;
    }

    public ParamAccessOperate() {
    }

    public static ParamAccessOperate Read(int interval, int area, int start, int len) {
        return new ParamAccessOperate(0, interval, new Read(area, start, len));
    }

    public static ParamAccessOperate Write(int interval, int area, int start, String hexWriteData) {
        return new ParamAccessOperate(1, interval, new Write(area, start, hexWriteData));
    }

    public static ParamAccessOperate Lock(int interval, int area, int type) {
        return new ParamAccessOperate(1, interval, new Lock(area, type));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getHexReadData() {
        return this.hexReadData;
    }

    public void setHexReadData(String hexReadData) {
        this.hexReadData = hexReadData;
    }

    @Override
    public byte[] toBytes() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.type, 8);
        buffer.putLong(this.interval, 32);
        byte[] bytes = this.parameter.toBytes();
        buffer.put(bytes);
        return buffer.asByteArray();
    }

    public String toString() {
        return "ParamAccessOperate{type=" + this.type + ", interval=" + this.interval + ", parameter=" + this.parameter + ", result=" + this.result + ", hexReadData='" + this.hexReadData + '\'' + '}';
    }

    public static class Read
    extends Parameter {
        private int area;
        private int start;
        private int len;

        public Read(int area, int start, int len) {
            this.area = area;
            this.start = start;
            this.len = len;
        }

        public Read() {
        }

        public int getArea() {
            return this.area;
        }

        public void setArea(int area) {
            this.area = area;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getLen() {
            return this.len;
        }

        public void setLen(int len) {
            this.len = len;
        }

        @Override
        public byte[] toBytes() {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.area, 8);
            buffer.putLong(this.start, 16);
            buffer.putLong(this.len, 8);
            return buffer.asByteArray();
        }

        public String toString() {
            return "Read{area=" + this.area + ", start=" + this.start + ", len=" + this.len + '}';
        }
    }

    public static class Write
    extends Parameter {
        private int area;
        private int start;
        private String hexWriteData;

        public Write() {
        }

        public Write(int area, int start, String hexWriteData) {
            this.area = area;
            this.start = start;
            this.hexWriteData = hexWriteData;
        }

        public int getArea() {
            return this.area;
        }

        public void setArea(int area) {
            this.area = area;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public String getHexWriteData() {
            return this.hexWriteData;
        }

        public void setHexWriteData(String hexWriteData) {
            this.hexWriteData = hexWriteData;
        }

        @Override
        public byte[] toBytes() {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.area, 8);
            buffer.putLong(this.start, 16);
            if (!StringUtils.isNullOfEmpty(this.hexWriteData)) {
                buffer.put(HexUtils.hexString2Bytes(this.hexWriteData));
            }
            return buffer.asByteArray();
        }

        public String toString() {
            return "Write{area=" + this.area + ", start=" + this.start + ", hexWriteData='" + this.hexWriteData + '\'' + '}';
        }
    }

    public static class Lock
    extends Parameter {
        private int area;
        private int type;

        public Lock() {
        }

        public Lock(int area, int type) {
            this.area = area;
            this.type = type;
        }

        public int getArea() {
            return this.area;
        }

        public void setArea(int area) {
            this.area = area;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        @Override
        public byte[] toBytes() {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.area, 8);
            buffer.putLong(this.type, 8);
            return buffer.asByteArray();
        }

        public String toString() {
            return "Lock{area=" + this.area + ", type=" + this.type + '}';
        }
    }
}

