/*
 * Decompiled with CFR 0.152.
 */
package com.peripheral.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.peripheral.ble.BluetoothBytesParser;
import com.peripheral.ble.BluetoothPeripheralCallback;
import com.peripheral.ble.BondState;
import com.peripheral.ble.ConnectionPriority;
import com.peripheral.ble.ConnectionState;
import com.peripheral.ble.GattStatus;
import com.peripheral.ble.HciStatus;
import com.peripheral.ble.Logger;
import com.peripheral.ble.PeripheralType;
import com.peripheral.ble.PhyOptions;
import com.peripheral.ble.PhyType;
import com.peripheral.ble.Transport;
import com.peripheral.ble.WriteType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BluetoothPeripheral {
    private static final String TAG = BluetoothPeripheral.class.getSimpleName();
    private static final UUID CCC_DESCRIPTOR_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    public static final int MAX_MTU = 517;
    private static final int DEFAULT_MTU = 23;
    private static final int MAX_TRIES = 2;
    private static final int DIRECT_CONNECTION_DELAY_IN_MS = 100;
    private static final int CONNECTION_TIMEOUT_IN_MS = 35000;
    private static final int TIMEOUT_THRESHOLD_SAMSUNG = 4500;
    private static final int TIMEOUT_THRESHOLD_DEFAULT = 25000;
    private static final long DELAY_AFTER_BOND_LOST = 1000L;
    private static final long AVG_REQUEST_CONNECTION_PRIORITY_DURATION = 500L;
    private static final String NO_VALID_SERVICE_UUID_PROVIDED = "no valid service UUID provided";
    private static final String NO_VALID_CHARACTERISTIC_UUID_PROVIDED = "no valid characteristic UUID provided";
    private static final String NO_VALID_CHARACTERISTIC_PROVIDED = "no valid characteristic provided";
    private static final String NO_VALID_WRITE_TYPE_PROVIDED = "no valid writeType provided";
    private static final String NO_VALID_VALUE_PROVIDED = "no valid value provided";
    private static final String NO_VALID_DESCRIPTOR_PROVIDED = "no valid descriptor provided";
    private static final String NO_VALID_PERIPHERAL_CALLBACK_PROVIDED = "no valid peripheral callback provided";
    private static final String NO_VALID_DEVICE_PROVIDED = "no valid device provided";
    private static final String NO_VALID_PRIORITY_PROVIDED = "no valid priority provided";
    private static final String PERIPHERAL_NOT_CONNECTED = "peripheral not connected";
    private static final String VALUE_BYTE_ARRAY_IS_EMPTY = "value byte array is empty";
    private static final String VALUE_BYTE_ARRAY_IS_TOO_LONG = "value byte array is too long";
    private static final int IDLE = 0;
    private static final int REQUEST_MTU_COMMAND = 1;
    private static final int SET_PHY_TYPE_COMMAND = 2;
    private final Context context;
    private final Handler callbackHandler;
    private BluetoothDevice device;
    private final PeripheralType peripheralType;
    private final InternalCallback listener;
    protected BluetoothPeripheralCallback peripheralCallback;
    private final Queue<Runnable> commandQueue = new ConcurrentLinkedQueue<Runnable>();
    private volatile BluetoothGatt bluetoothGatt;
    private String cachedName = "";
    private byte[] currentWriteBytes = new byte[0];
    private int currentCommand = 0;
    private final Set<BluetoothGattCharacteristic> notifyingCharacteristics = new HashSet<BluetoothGattCharacteristic>();
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private Runnable timeoutRunnable;
    private Runnable discoverServicesRunnable;
    private volatile boolean commandQueueBusy = false;
    private boolean isRetrying;
    private boolean bondLost = false;
    private boolean manuallyBonding = false;
    private volatile boolean peripheralInitiatedBonding = false;
    private boolean discoveryStarted = false;
    private volatile int state = 0;
    private int nrTries;
    private long connectTimestamp;
    private int currentMtu = 23;
    private final Transport transport;
    private final BluetoothGattCallback bluetoothGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            if (newState != 1) {
                BluetoothPeripheral.this.cancelConnectionTimer();
            }
            int previousState = BluetoothPeripheral.this.state;
            BluetoothPeripheral.this.state = newState;
            HciStatus hciStatus = HciStatus.fromValue(status);
            if (hciStatus == HciStatus.SUCCESS) {
                switch (newState) {
                    case 2: {
                        BluetoothPeripheral.this.successfullyConnected();
                        break;
                    }
                    case 0: {
                        BluetoothPeripheral.this.successfullyDisconnected(previousState);
                        break;
                    }
                    case 3: {
                        Logger.i(TAG, "peripheral '%s' is disconnecting", BluetoothPeripheral.this.getAddress());
                        BluetoothPeripheral.this.listener.disconnecting(BluetoothPeripheral.this);
                        break;
                    }
                    case 1: {
                        Logger.i(TAG, "peripheral '%s' is connecting", BluetoothPeripheral.this.getAddress());
                        BluetoothPeripheral.this.listener.connecting(BluetoothPeripheral.this);
                        break;
                    }
                    default: {
                        Logger.e(TAG, "unknown state received");
                        break;
                    }
                }
            } else {
                BluetoothPeripheral.this.connectionStateChangeUnsuccessful(hciStatus, previousState, newState);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Logger.e(TAG, "service discovery failed due to internal error '%s', disconnecting", new Object[]{gattStatus});
                BluetoothPeripheral.this.disconnect();
                return;
            }
            List services = gatt.getServices();
            Logger.i(TAG, "discovered %d services for '%s'", services.size(), BluetoothPeripheral.this.getName());
            BluetoothPeripheral.this.listener.connected(BluetoothPeripheral.this);
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onServicesDiscovered(BluetoothPeripheral.this);
                }
            });
        }

        public void onDescriptorWrite(BluetoothGatt gatt, final BluetoothGattDescriptor descriptor, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            final BluetoothGattCharacteristic parentCharacteristic = descriptor.getCharacteristic();
            if (gattStatus != GattStatus.SUCCESS) {
                Logger.e(TAG, "failed to write <%s> to descriptor of characteristic <%s> for device: '%s', status '%s' ", new Object[]{BluetoothBytesParser.asHexString(BluetoothPeripheral.this.currentWriteBytes), parentCharacteristic.getUuid(), BluetoothPeripheral.this.getAddress(), gattStatus});
                if (this.failureThatShouldTriggerBonding(gattStatus)) {
                    return;
                }
            }
            final byte[] value = BluetoothPeripheral.this.currentWriteBytes;
            BluetoothPeripheral.access$902(BluetoothPeripheral.this, new byte[0]);
            if (descriptor.getUuid().equals(CCC_DESCRIPTOR_UUID)) {
                if (gattStatus == GattStatus.SUCCESS) {
                    if (Arrays.equals(value, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE) || Arrays.equals(value, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) {
                        BluetoothPeripheral.this.notifyingCharacteristics.add(parentCharacteristic);
                    } else if (Arrays.equals(value, BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE)) {
                        BluetoothPeripheral.this.notifyingCharacteristics.remove(parentCharacteristic);
                    }
                }
                BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onNotificationStateUpdate(BluetoothPeripheral.this, parentCharacteristic, gattStatus);
                    }
                });
            } else {
                BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onDescriptorWrite(BluetoothPeripheral.this, value, descriptor, gattStatus);
                    }
                });
            }
            BluetoothPeripheral.this.completedCommand();
        }

        public void onDescriptorRead(BluetoothGatt gatt, final BluetoothGattDescriptor descriptor, int status, byte[] value) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Logger.e(TAG, "reading descriptor <%s> failed for device '%s, status '%s'", new Object[]{descriptor.getUuid(), BluetoothPeripheral.this.getAddress(), gattStatus});
                if (this.failureThatShouldTriggerBonding(gattStatus)) {
                    return;
                }
            }
            final byte[] safeValue = BluetoothPeripheral.this.nonnullOf(value);
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onDescriptorRead(BluetoothPeripheral.this, safeValue, descriptor, gattStatus);
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            if (Build.VERSION.SDK_INT < 33) {
                this.onDescriptorRead(gatt, descriptor, status, descriptor.getValue());
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] value) {
            byte[] safeValue = BluetoothPeripheral.this.nonnullOf(value);
            BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, safeValue, characteristic, GattStatus.SUCCESS);
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            if (Build.VERSION.SDK_INT < 33) {
                this.onCharacteristicChanged(gatt, characteristic, characteristic.getValue());
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, byte[] value, int status) {
            GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Logger.e(TAG, "read failed for characteristic <%s>, status '%s'", new Object[]{characteristic.getUuid(), gattStatus});
                if (this.failureThatShouldTriggerBonding(gattStatus)) {
                    return;
                }
            }
            byte[] safeValue = BluetoothPeripheral.this.nonnullOf(value);
            BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, safeValue, characteristic, gattStatus);
            BluetoothPeripheral.this.completedCommand();
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (Build.VERSION.SDK_INT < 33) {
                this.onCharacteristicRead(gatt, characteristic, characteristic.getValue(), status);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Logger.e(TAG, "writing <%s> to characteristic <%s> failed, status '%s'", new Object[]{BluetoothBytesParser.asHexString(BluetoothPeripheral.this.currentWriteBytes), characteristic.getUuid(), gattStatus});
                if (this.failureThatShouldTriggerBonding(gattStatus)) {
                    return;
                }
            }
            byte[] value = BluetoothPeripheral.this.currentWriteBytes;
            BluetoothPeripheral.access$902(BluetoothPeripheral.this, new byte[0]);
            BluetoothPeripheral.this.peripheralCallback.onCharacteristicWrite(BluetoothPeripheral.this, value, characteristic, gattStatus);
            BluetoothPeripheral.this.completedCommand();
        }

        private boolean failureThatShouldTriggerBonding(GattStatus gattStatus) {
            if ((gattStatus == GattStatus.AUTHORIZATION_FAILED || gattStatus == GattStatus.INSUFFICIENT_AUTHENTICATION || gattStatus == GattStatus.INSUFFICIENT_ENCRYPTION) && Build.VERSION.SDK_INT < 26) {
                Logger.i(TAG, "operation will be retried after bonding, bonding should be in progress");
                return true;
            }
            return false;
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, final int rssi, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Logger.e(TAG, "reading RSSI failed, status '%s'", new Object[]{gattStatus});
            }
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onReadRemoteRssi(BluetoothPeripheral.this, rssi, gattStatus);
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onMtuChanged(BluetoothGatt gatt, final int mtu, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Logger.e(TAG, "change MTU failed, status '%s'", new Object[]{gattStatus});
            }
            BluetoothPeripheral.this.currentMtu = mtu;
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onMtuChanged(BluetoothPeripheral.this, mtu, gattStatus);
                }
            });
            if (BluetoothPeripheral.this.currentCommand == 1) {
                BluetoothPeripheral.this.currentCommand = 0;
                BluetoothPeripheral.this.completedCommand();
            }
        }

        public void onPhyRead(BluetoothGatt gatt, final int txPhy, final int rxPhy, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Logger.e(TAG, "read Phy failed, status '%s'", new Object[]{gattStatus});
            } else {
                Logger.i(TAG, "updated Phy: tx = %s, rx = %s", new Object[]{PhyType.fromValue(txPhy), PhyType.fromValue(rxPhy)});
            }
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onPhyUpdate(BluetoothPeripheral.this, PhyType.fromValue(txPhy), PhyType.fromValue(rxPhy), gattStatus);
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onPhyUpdate(BluetoothGatt gatt, final int txPhy, final int rxPhy, int status) {
            final GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus != GattStatus.SUCCESS) {
                Logger.e(TAG, "update Phy failed, status '%s'", new Object[]{gattStatus});
            } else {
                Logger.i(TAG, "updated Phy: tx = %s, rx = %s", new Object[]{PhyType.fromValue(txPhy), PhyType.fromValue(rxPhy)});
            }
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onPhyUpdate(BluetoothPeripheral.this, PhyType.fromValue(txPhy), PhyType.fromValue(rxPhy), gattStatus);
                }
            });
            if (BluetoothPeripheral.this.currentCommand == 2) {
                BluetoothPeripheral.this.currentCommand = 0;
                BluetoothPeripheral.this.completedCommand();
            }
        }

        public void onConnectionUpdated(BluetoothGatt gatt, int interval, int latency, int timeout, int status) {
            GattStatus gattStatus = GattStatus.fromValue(status);
            if (gattStatus == GattStatus.SUCCESS) {
                String msg = String.format(Locale.ENGLISH, "connection parameters: interval=%.1fms latency=%d timeout=%ds", Float.valueOf((float)interval * 1.25f), latency, timeout / 100);
                Logger.d(TAG, msg);
            } else {
                Logger.e(TAG, "connection parameters update failed with status '%s'", new Object[]{gattStatus});
            }
            BluetoothPeripheral.this.peripheralCallback.onConnectionUpdated(BluetoothPeripheral.this, interval, latency, timeout, gattStatus);
        }

        public void onServiceChanged(BluetoothGatt gatt) {
            Logger.d(TAG, "onServiceChangedCalled");
            BluetoothPeripheral.this.commandQueue.clear();
            BluetoothPeripheral.this.commandQueueBusy = false;
            BluetoothPeripheral.this.delayedDiscoverServices(100L);
        }
    };
    private final BroadcastReceiver bondStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            BluetoothDevice receivedDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (receivedDevice == null) {
                return;
            }
            if (!receivedDevice.getAddress().equalsIgnoreCase(BluetoothPeripheral.this.getAddress())) {
                return;
            }
            if (action.equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) {
                int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                int previousBondState = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", Integer.MIN_VALUE);
                BluetoothPeripheral.this.handleBondStateChange(bondState, previousBondState);
            }
        }
    };
    private final BroadcastReceiver pairingRequestBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String pin;
            BluetoothDevice receivedDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (receivedDevice == null) {
                return;
            }
            if (!receivedDevice.getAddress().equalsIgnoreCase(BluetoothPeripheral.this.getAddress())) {
                return;
            }
            int variant = intent.getIntExtra("android.bluetooth.device.extra.PAIRING_VARIANT", Integer.MIN_VALUE);
            Logger.d(TAG, "pairing request received: " + BluetoothPeripheral.this.pairingVariantToString(variant) + " (" + variant + ")");
            if (variant == 0 && (pin = BluetoothPeripheral.this.listener.getPincode(BluetoothPeripheral.this)) != null) {
                Logger.d(TAG, "setting PIN code for this peripheral using '%s'", pin);
                receivedDevice.setPin(pin.getBytes());
                this.abortBroadcast();
            }
        }
    };
    private static final int PAIRING_VARIANT_PIN = 0;
    private static final int PAIRING_VARIANT_PASSKEY = 1;
    private static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    private static final int PAIRING_VARIANT_CONSENT = 3;
    private static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    private static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    private static final int PAIRING_VARIANT_OOB_CONSENT = 6;

    private void successfullyConnected() {
        BondState bondstate = this.getBondState();
        long timePassed = SystemClock.elapsedRealtime() - this.connectTimestamp;
        Logger.i(TAG, "connected to '%s' (%s) in %.1fs", new Object[]{this.getName(), bondstate, Float.valueOf((float)timePassed / 1000.0f)});
        if (bondstate == BondState.NONE || bondstate == BondState.BONDED) {
            this.delayedDiscoverServices(this.getServiceDiscoveryDelay(bondstate));
        } else if (bondstate == BondState.BONDING) {
            Logger.i(TAG, "waiting for bonding to complete");
        }
    }

    private void delayedDiscoverServices(final long delay) {
        this.discoverServicesRunnable = new Runnable(){

            @Override
            public void run() {
                Logger.d(TAG, "discovering services of '%s' with delay of %d ms", BluetoothPeripheral.this.getName(), delay);
                if (BluetoothPeripheral.this.bluetoothGatt != null && BluetoothPeripheral.this.bluetoothGatt.discoverServices()) {
                    BluetoothPeripheral.this.discoveryStarted = true;
                } else {
                    Logger.e(TAG, "discoverServices failed to start");
                }
                BluetoothPeripheral.this.discoverServicesRunnable = null;
            }
        };
        this.mainHandler.postDelayed(this.discoverServicesRunnable, delay);
    }

    private long getServiceDiscoveryDelay(BondState bondstate) {
        long delayWhenBonded = 0L;
        if (Build.VERSION.SDK_INT <= 24) {
            delayWhenBonded = 1000L;
        }
        return bondstate == BondState.BONDED ? delayWhenBonded : 0L;
    }

    private void successfullyDisconnected(int previousState) {
        if (previousState == 2 || previousState == 3) {
            Logger.i(TAG, "disconnected '%s' on request", this.getName());
        } else if (previousState == 1) {
            Logger.i(TAG, "cancelling connect attempt");
        }
        if (this.bondLost) {
            Logger.d(TAG, "disconnected because of bond lost");
            this.callbackHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.getServices().isEmpty()) {
                        BluetoothPeripheral.this.completeDisconnect(false, HciStatus.AUTHENTICATION_FAILURE);
                        BluetoothPeripheral.this.listener.connectFailed(BluetoothPeripheral.this, HciStatus.AUTHENTICATION_FAILURE);
                    } else {
                        BluetoothPeripheral.this.completeDisconnect(true, HciStatus.AUTHENTICATION_FAILURE);
                    }
                }
            }, 1000L);
        } else {
            this.completeDisconnect(true, HciStatus.SUCCESS);
        }
    }

    private void connectionStateChangeUnsuccessful(HciStatus status, int previousState, int newState) {
        boolean servicesDiscovered;
        this.cancelPendingServiceDiscovery();
        boolean bl = servicesDiscovered = !this.getServices().isEmpty();
        if (previousState == 1) {
            long timePassed = SystemClock.elapsedRealtime() - this.connectTimestamp;
            boolean isTimeout = timePassed > (long)this.getTimoutThreshold();
            HciStatus adjustedStatus = status == HciStatus.ERROR && isTimeout ? HciStatus.CONNECTION_FAILED_ESTABLISHMENT : status;
            Logger.i(TAG, "connection failed with status '%s'", new Object[]{adjustedStatus});
            this.completeDisconnect(false, adjustedStatus);
            this.listener.connectFailed(this, adjustedStatus);
        } else if (previousState == 2 && newState == 0 && !servicesDiscovered) {
            Logger.i(TAG, "peripheral '%s' disconnected with status '%s' (%d) before completing service discovery", new Object[]{this.getName(), status, status.value});
            this.completeDisconnect(false, status);
            this.listener.connectFailed(this, status);
        } else {
            if (newState == 0) {
                Logger.i(TAG, "peripheral '%s' disconnected with status '%s' (%d)", new Object[]{this.getName(), status, status.value});
            } else {
                Logger.i(TAG, "unexpected connection state change for '%s' status '%s' (%d)", new Object[]{this.getName(), status, status.value});
            }
            this.completeDisconnect(true, status);
        }
    }

    private void cancelPendingServiceDiscovery() {
        if (this.discoverServicesRunnable != null) {
            this.mainHandler.removeCallbacks(this.discoverServicesRunnable);
            this.discoverServicesRunnable = null;
        }
    }

    private void handleBondStateChange(int bondState, int previousBondState) {
        switch (bondState) {
            case 11: {
                Logger.d(TAG, "starting bonding with '%s' (%s)", this.getName(), this.getAddress());
                this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onBondingStarted(BluetoothPeripheral.this);
                    }
                });
                break;
            }
            case 12: {
                Logger.d(TAG, "bonded with '%s' (%s)", this.getName(), this.getAddress());
                this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onBondingSucceeded(BluetoothPeripheral.this);
                    }
                });
                if (this.bluetoothGatt == null) {
                    this.connect();
                    return;
                }
                if (this.getServices().isEmpty() && !this.discoveryStarted) {
                    this.delayedDiscoverServices(0L);
                }
                if (Build.VERSION.SDK_INT < 26 && this.commandQueueBusy && !this.manuallyBonding) {
                    this.mainHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Logger.d(TAG, "retrying command after bonding");
                            BluetoothPeripheral.this.retryCommand();
                        }
                    }, 50L);
                }
                if (this.manuallyBonding) {
                    this.manuallyBonding = false;
                    this.completedCommand();
                }
                if (!this.peripheralInitiatedBonding) break;
                this.peripheralInitiatedBonding = false;
                this.nextCommand();
                break;
            }
            case 10: {
                if (previousBondState == 11) {
                    Logger.e(TAG, "bonding failed for '%s', disconnecting device", this.getName());
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothPeripheral.this.peripheralCallback.onBondingFailed(BluetoothPeripheral.this);
                        }
                    });
                } else {
                    Logger.e(TAG, "bond lost for '%s'", this.getName());
                    this.bondLost = true;
                    this.cancelPendingServiceDiscovery();
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothPeripheral.this.peripheralCallback.onBondLost(BluetoothPeripheral.this);
                        }
                    });
                }
                this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothPeripheral.this.getState() == ConnectionState.CONNECTED) {
                            BluetoothPeripheral.this.disconnect();
                        }
                    }
                }, 100L);
            }
        }
    }

    BluetoothPeripheral(Context context, BluetoothDevice device, InternalCallback listener, BluetoothPeripheralCallback peripheralCallback, Handler callbackHandler, Transport transport) {
        this.context = Objects.requireNonNull(context, "no valid context provided");
        this.device = Objects.requireNonNull(device, NO_VALID_DEVICE_PROVIDED);
        this.peripheralType = PeripheralType.fromValue(device.getType());
        this.listener = Objects.requireNonNull(listener, "no valid listener provided");
        this.peripheralCallback = Objects.requireNonNull(peripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_PROVIDED);
        this.callbackHandler = Objects.requireNonNull(callbackHandler, "no valid callback handler provided");
        this.transport = Objects.requireNonNull(transport, "no valid transport provided");
    }

    void setPeripheralCallback(BluetoothPeripheralCallback peripheralCallback) {
        this.peripheralCallback = Objects.requireNonNull(peripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_PROVIDED);
    }

    void setDevice(BluetoothDevice bluetoothDevice) {
        this.device = Objects.requireNonNull(bluetoothDevice, NO_VALID_DEVICE_PROVIDED);
    }

    void connect() {
        if (this.state == 0) {
            Logger.i(TAG, "connect to '%s' (%s) using transport %s", this.getName(), this.getAddress(), this.transport.name());
            this.registerBondingBroadcastReceivers();
            this.discoveryStarted = false;
            this.connectTimestamp = SystemClock.elapsedRealtime();
            this.bluetoothGatt = this.connectGattHelper(this.device, false, this.bluetoothGattCallback);
            if (this.bluetoothGatt != null) {
                this.bluetoothGattCallback.onConnectionStateChange(this.bluetoothGatt, HciStatus.SUCCESS.value, 1);
                this.startConnectionTimer(this);
            } else {
                Logger.e(TAG, "failed to connect to peripheral '%s'", this.getAddress());
            }
        } else {
            Logger.e(TAG, "peripheral '%s' not yet disconnected, will not connect", this.getName());
        }
    }

    void autoConnect() {
        if (this.state == 0) {
            Logger.i(TAG, "autoConnect to '%s' (%s) using transport %s", this.getName(), this.getAddress(), this.transport.name());
            this.registerBondingBroadcastReceivers();
            this.discoveryStarted = false;
            this.connectTimestamp = SystemClock.elapsedRealtime();
            this.bluetoothGatt = this.connectGattHelper(this.device, true, this.bluetoothGattCallback);
            if (this.bluetoothGatt != null) {
                this.bluetoothGattCallback.onConnectionStateChange(this.bluetoothGatt, HciStatus.SUCCESS.value, 1);
            } else {
                Logger.e(TAG, "failed to autoconnect to peripheral '%s'", this.getAddress());
            }
        } else {
            Logger.e(TAG, "peripheral '%s' not yet disconnected, will not connect", this.getName());
        }
    }

    private void registerBondingBroadcastReceivers() {
        this.context.registerReceiver(this.bondStateReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
        this.context.registerReceiver(this.pairingRequestBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.PAIRING_REQUEST"));
    }

    public boolean createBond() {
        if (this.bluetoothGatt == null) {
            Logger.d(TAG, "connecting and creating bond with '%s'", this.getName());
            this.registerBondingBroadcastReceivers();
            return this.device.createBond();
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                BluetoothPeripheral.this.manuallyBonding = true;
                if (!BluetoothPeripheral.this.device.createBond()) {
                    Logger.e(TAG, "bonding failed for %s", BluetoothPeripheral.this.getAddress());
                    BluetoothPeripheral.this.completedCommand();
                } else {
                    Logger.d(TAG, "manually bonding %s", BluetoothPeripheral.this.getAddress());
                    BluetoothPeripheral.this.nrTries++;
                }
            }
        });
    }

    public void cancelConnection() {
        if (this.bluetoothGatt == null) {
            Logger.w(TAG, "cannot cancel connection because no connection attempt is made yet");
            return;
        }
        if (this.state == 0 || this.state == 3) {
            return;
        }
        this.cancelConnectionTimer();
        if (this.state == 1) {
            this.disconnect();
            this.mainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.bluetoothGatt != null) {
                        BluetoothPeripheral.this.bluetoothGattCallback.onConnectionStateChange(BluetoothPeripheral.this.bluetoothGatt, HciStatus.SUCCESS.value, 0);
                    }
                }
            }, 50L);
        } else {
            this.disconnect();
        }
    }

    private void disconnect() {
        if (this.state == 2 || this.state == 1) {
            if (this.bluetoothGatt != null) {
                this.bluetoothGattCallback.onConnectionStateChange(this.bluetoothGatt, HciStatus.SUCCESS.value, 3);
            }
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.state == 3 && BluetoothPeripheral.this.bluetoothGatt != null) {
                        BluetoothPeripheral.this.bluetoothGatt.disconnect();
                        Logger.i(TAG, "force disconnect '%s' (%s)", BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress());
                    }
                }
            });
        } else {
            this.listener.disconnected(this, HciStatus.SUCCESS);
        }
    }

    void disconnectWhenBluetoothOff() {
        this.completeDisconnect(true, HciStatus.SUCCESS);
    }

    private void completeDisconnect(boolean notify, HciStatus status) {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
            this.bluetoothGatt = null;
        }
        this.commandQueue.clear();
        this.commandQueueBusy = false;
        this.notifyingCharacteristics.clear();
        this.currentMtu = 23;
        this.currentCommand = 0;
        this.manuallyBonding = false;
        this.peripheralInitiatedBonding = false;
        this.discoveryStarted = false;
        try {
            this.context.unregisterReceiver(this.bondStateReceiver);
            this.context.unregisterReceiver(this.pairingRequestBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.bondLost = false;
        if (notify) {
            this.listener.disconnected(this, status);
        }
    }

    public String getAddress() {
        return this.device.getAddress();
    }

    public PeripheralType getType() {
        return this.peripheralType;
    }

    public String getName() {
        String name = this.device.getName();
        if (name != null) {
            this.cachedName = name;
            return name;
        }
        return this.cachedName;
    }

    public BondState getBondState() {
        return BondState.fromValue(this.device.getBondState());
    }

    public List<BluetoothGattService> getServices() {
        if (this.bluetoothGatt != null) {
            return this.bluetoothGatt.getServices();
        }
        return Collections.emptyList();
    }

    public BluetoothGattService getService(UUID serviceUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        if (this.bluetoothGatt != null) {
            return this.bluetoothGatt.getService(serviceUUID);
        }
        return null;
    }

    public BluetoothGattCharacteristic getCharacteristic(UUID serviceUUID, UUID characteristicUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        BluetoothGattService service = this.getService(serviceUUID);
        if (service != null) {
            return service.getCharacteristic(characteristicUUID);
        }
        return null;
    }

    public ConnectionState getState() {
        return ConnectionState.fromValue(this.state);
    }

    public int getCurrentMtu() {
        return this.currentMtu;
    }

    public int getMaximumWriteValueLength(WriteType writeType) {
        Objects.requireNonNull(writeType, "writetype is null");
        switch (writeType) {
            case WITH_RESPONSE: {
                return 512;
            }
            case SIGNED: {
                return this.currentMtu - 15;
            }
        }
        return this.currentMtu - 3;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public boolean isNotifying(BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        return this.notifyingCharacteristics.contains(characteristic);
    }

    public Set<BluetoothGattCharacteristic> getNotifyingCharacteristics() {
        return Collections.unmodifiableSet(this.notifyingCharacteristics);
    }

    private boolean isConnected() {
        return this.bluetoothGatt != null && this.state == 2;
    }

    private boolean notConnected() {
        return !this.isConnected();
    }

    public boolean isUncached() {
        return this.getType() == PeripheralType.UNKNOWN;
    }

    public boolean readCharacteristic(UUID serviceUUID, UUID characteristicUUID) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        BluetoothGattCharacteristic characteristic = this.getCharacteristic(serviceUUID, characteristicUUID);
        if (characteristic != null) {
            return this.readCharacteristic(characteristic);
        }
        return false;
    }

    public boolean readCharacteristic(final BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        if (this.doesNotSupportReading(characteristic)) {
            String message = String.format("characteristic <%s> does not have read property", characteristic.getUuid());
            throw new IllegalArgumentException(message);
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.bluetoothGatt.readCharacteristic(characteristic)) {
                    Logger.d(TAG, "reading characteristic <%s>", characteristic.getUuid());
                    BluetoothPeripheral.this.nrTries++;
                } else {
                    Logger.e(TAG, "readCharacteristic failed for characteristic: %s", characteristic.getUuid());
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    private boolean doesNotSupportReading(BluetoothGattCharacteristic characteristic) {
        return (characteristic.getProperties() & 2) == 0;
    }

    public boolean writeCharacteristic(UUID serviceUUID, UUID characteristicUUID, byte[] value, WriteType writeType) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        Objects.requireNonNull(value, NO_VALID_VALUE_PROVIDED);
        Objects.requireNonNull(writeType, NO_VALID_WRITE_TYPE_PROVIDED);
        BluetoothGattCharacteristic characteristic = this.getCharacteristic(serviceUUID, characteristicUUID);
        if (characteristic != null) {
            return this.writeCharacteristic(characteristic, value, writeType);
        }
        return false;
    }

    public boolean writeCharacteristic(final BluetoothGattCharacteristic characteristic, byte[] value, final WriteType writeType) {
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        Objects.requireNonNull(value, NO_VALID_VALUE_PROVIDED);
        Objects.requireNonNull(writeType, NO_VALID_WRITE_TYPE_PROVIDED);
        if (value.length == 0) {
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_EMPTY);
        }
        if (value.length > this.getMaximumWriteValueLength(writeType)) {
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_TOO_LONG);
        }
        if (this.doesNotSupportWriteType(characteristic, writeType)) {
            String message = String.format("characteristic <%s> does not support writeType '%s'", new Object[]{characteristic.getUuid(), writeType});
            throw new IllegalArgumentException(message);
        }
        final byte[] bytesToWrite = this.copyOf(value);
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.willCauseLongWrite(bytesToWrite, writeType)) {
                    Logger.w(TAG, "value byte array is longer than allowed by MTU, write will fail if peripheral does not support long writes");
                }
                if (BluetoothPeripheral.this.internalWriteCharacteristic(characteristic, bytesToWrite, writeType)) {
                    Logger.d(TAG, "writing <%s> to characteristic <%s>", BluetoothBytesParser.asHexString(bytesToWrite), characteristic.getUuid());
                    BluetoothPeripheral.this.nrTries++;
                } else {
                    Logger.e(TAG, "writeCharacteristic failed for characteristic: %s", characteristic.getUuid());
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    private boolean willCauseLongWrite(byte[] value, WriteType writeType) {
        return value.length > this.currentMtu - 3 && writeType == WriteType.WITH_RESPONSE;
    }

    private boolean doesNotSupportWriteType(BluetoothGattCharacteristic characteristic, WriteType writeType) {
        return (characteristic.getProperties() & writeType.property) == 0;
    }

    private boolean internalWriteCharacteristic(BluetoothGattCharacteristic characteristic, byte[] value, WriteType writeType) {
        if (this.bluetoothGatt == null) {
            return false;
        }
        this.currentWriteBytes = value;
        if (Build.VERSION.SDK_INT >= 33) {
            int result = this.bluetoothGatt.writeCharacteristic(characteristic, this.currentWriteBytes, writeType.writeType);
            return result == 0;
        }
        characteristic.setWriteType(writeType.writeType);
        characteristic.setValue(value);
        return this.bluetoothGatt.writeCharacteristic(characteristic);
    }

    public boolean readDescriptor(final BluetoothGattDescriptor descriptor) {
        Objects.requireNonNull(descriptor, NO_VALID_DESCRIPTOR_PROVIDED);
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.bluetoothGatt.readDescriptor(descriptor)) {
                    Logger.d(TAG, "reading descriptor <%s>", descriptor.getUuid());
                    BluetoothPeripheral.this.nrTries++;
                } else {
                    Logger.e(TAG, "readDescriptor failed for characteristic: %s", descriptor.getUuid());
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    public boolean writeDescriptor(final BluetoothGattDescriptor descriptor, byte[] value) {
        Objects.requireNonNull(descriptor, NO_VALID_DESCRIPTOR_PROVIDED);
        Objects.requireNonNull(value, NO_VALID_VALUE_PROVIDED);
        if (value.length == 0) {
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_EMPTY);
        }
        if (value.length > this.getMaximumWriteValueLength(WriteType.WITH_RESPONSE)) {
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_TOO_LONG);
        }
        final byte[] bytesToWrite = this.copyOf(value);
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.internalWriteDescriptor(descriptor, bytesToWrite)) {
                    Logger.d(TAG, "writing <%s> to descriptor <%s>", BluetoothBytesParser.asHexString(bytesToWrite), descriptor.getUuid());
                    BluetoothPeripheral.this.nrTries++;
                } else {
                    Logger.e(TAG, "writeDescriptor failed for descriptor: %s", descriptor.getUuid());
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    private boolean internalWriteDescriptor(BluetoothGattDescriptor descriptor, byte[] value) {
        if (this.bluetoothGatt == null) {
            return false;
        }
        this.currentWriteBytes = value;
        if (Build.VERSION.SDK_INT >= 33) {
            int result = this.bluetoothGatt.writeDescriptor(descriptor, value);
            return result == 0;
        }
        this.adjustWriteTypeIfNeeded(descriptor.getCharacteristic());
        descriptor.setValue(value);
        return this.bluetoothGatt.writeDescriptor(descriptor);
    }

    public boolean setNotify(UUID serviceUUID, UUID characteristicUUID, boolean enable) {
        Objects.requireNonNull(serviceUUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(characteristicUUID, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        BluetoothGattCharacteristic characteristic = this.getCharacteristic(serviceUUID, characteristicUUID);
        if (characteristic != null) {
            return this.setNotify(characteristic, enable);
        }
        return false;
    }

    public boolean setNotify(final BluetoothGattCharacteristic characteristic, final boolean enable) {
        byte[] value;
        Objects.requireNonNull(characteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        final BluetoothGattDescriptor descriptor = characteristic.getDescriptor(CCC_DESCRIPTOR_UUID);
        if (descriptor == null) {
            String message = String.format("could not get CCC descriptor for characteristic %s", characteristic.getUuid());
            throw new IllegalArgumentException(message);
        }
        int properties = characteristic.getProperties();
        if ((properties & 0x10) > 0) {
            value = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
        } else if ((properties & 0x20) > 0) {
            value = BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
        } else {
            String message = String.format("characteristic %s does not have notify or indicate property", characteristic.getUuid());
            throw new IllegalArgumentException(message);
        }
        final byte[] finalValue = enable ? value : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (!BluetoothPeripheral.this.bluetoothGatt.setCharacteristicNotification(characteristic, enable)) {
                    Logger.e(TAG, "setCharacteristicNotification failed for characteristic: %s", characteristic.getUuid());
                    BluetoothPeripheral.this.completedCommand();
                    return;
                }
                BluetoothPeripheral.access$902(BluetoothPeripheral.this, finalValue);
                if (BluetoothPeripheral.this.internalWriteDescriptor(descriptor, finalValue)) {
                    BluetoothPeripheral.this.nrTries++;
                } else {
                    Logger.e(TAG, "writeDescriptor failed for descriptor: %s", descriptor.getUuid());
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    private void adjustWriteTypeIfNeeded(BluetoothGattCharacteristic characteristic) {
        if (Build.VERSION.SDK_INT < 24) {
            characteristic.setWriteType(2);
        }
    }

    public boolean readRemoteRssi() {
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (!BluetoothPeripheral.this.bluetoothGatt.readRemoteRssi()) {
                    Logger.e(TAG, "readRemoteRssi failed");
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    public boolean requestMtu(final int mtu) {
        if (mtu < 23 || mtu > 517) {
            throw new IllegalArgumentException("mtu must be between 23 and 517");
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.bluetoothGatt.requestMtu(mtu)) {
                    BluetoothPeripheral.this.currentCommand = 1;
                    Logger.i(TAG, "requesting MTU of %d", mtu);
                } else {
                    Logger.e(TAG, "requestMtu failed");
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    public boolean requestConnectionPriority(final ConnectionPriority priority) {
        Objects.requireNonNull(priority, NO_VALID_PRIORITY_PROVIDED);
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.bluetoothGatt.requestConnectionPriority(priority.value)) {
                    Logger.d(TAG, "requesting connection priority %s", new Object[]{priority});
                } else {
                    Logger.e(TAG, "could not request connection priority");
                }
                BluetoothPeripheral.this.callbackHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.completedCommand();
                    }
                }, 500L);
            }
        });
    }

    public boolean setPreferredPhy(final PhyType txPhy, final PhyType rxPhy, final PhyOptions phyOptions) {
        Objects.requireNonNull(txPhy);
        Objects.requireNonNull(rxPhy);
        Objects.requireNonNull(phyOptions);
        if (Build.VERSION.SDK_INT < 26) {
            Logger.e(TAG, "setPreferredPhy requires Android 8.0 or newer");
            return false;
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT >= 26) {
                    BluetoothPeripheral.this.currentCommand = 2;
                    Logger.i(TAG, "setting preferred Phy: tx = %s, rx = %s, options = %s", new Object[]{txPhy, rxPhy, phyOptions});
                    BluetoothPeripheral.this.bluetoothGatt.setPreferredPhy(txPhy.mask, rxPhy.mask, phyOptions.value);
                    if (Build.VERSION.SDK_INT == 33) {
                        BluetoothPeripheral.this.currentCommand = 0;
                        BluetoothPeripheral.this.callbackHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                BluetoothPeripheral.this.completedCommand();
                            }
                        }, 200L);
                    }
                }
            }
        });
    }

    public boolean readPhy() {
        if (Build.VERSION.SDK_INT < 26) {
            Logger.e(TAG, "setPreferredPhy requires Android 8.0 or newer");
            return false;
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT >= 26) {
                    BluetoothPeripheral.this.bluetoothGatt.readPhy();
                    Logger.d(TAG, "reading Phy");
                }
            }
        });
    }

    public boolean clearServicesCache() {
        if (this.bluetoothGatt == null) {
            return false;
        }
        boolean result = false;
        try {
            Method refreshMethod = this.bluetoothGatt.getClass().getMethod("refresh", new Class[0]);
            if (refreshMethod != null) {
                result = (Boolean)refreshMethod.invoke((Object)this.bluetoothGatt, new Object[0]);
            }
        }
        catch (Exception e) {
            Logger.e(TAG, "could not invoke refresh method");
        }
        return result;
    }

    private boolean enqueue(Runnable command) {
        if (this.notConnected()) {
            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
            return false;
        }
        boolean result = this.commandQueue.add(command);
        if (result) {
            this.nextCommand();
        } else {
            Logger.e(TAG, "could not enqueue command");
        }
        return result;
    }

    private void completedCommand() {
        this.isRetrying = false;
        this.commandQueue.poll();
        this.commandQueueBusy = false;
        this.nextCommand();
    }

    private void retryCommand() {
        this.commandQueueBusy = false;
        Runnable currentCommand = this.commandQueue.peek();
        if (currentCommand != null) {
            if (this.nrTries >= 2) {
                Logger.d(TAG, "max number of tries reached, not retrying operation anymore");
                this.commandQueue.poll();
            } else {
                this.isRetrying = true;
            }
        }
        this.nextCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextCommand() {
        BluetoothPeripheral bluetoothPeripheral = this;
        synchronized (bluetoothPeripheral) {
            if (this.commandQueueBusy) {
                return;
            }
            Runnable bluetoothCommand = this.commandQueue.peek();
            if (bluetoothCommand == null) {
                return;
            }
            if (this.bluetoothGatt == null) {
                Logger.e(TAG, "gatt is 'null' for peripheral '%s', clearing command queue", this.getAddress());
                this.commandQueue.clear();
                this.commandQueueBusy = false;
                return;
            }
            if (this.getBondState() == BondState.BONDING) {
                Logger.w(TAG, "bonding is in progress, waiting for bonding to complete");
                this.peripheralInitiatedBonding = true;
                return;
            }
            this.commandQueueBusy = true;
            if (!this.isRetrying) {
                this.nrTries = 0;
            }
            try {
                if (this.isConnected()) {
                    bluetoothCommand.run();
                }
            }
            catch (Exception ex) {
                Logger.e(TAG, "command exception for device '%s'", this.getName());
                Logger.e(TAG, ex.toString());
                this.completedCommand();
            }
        }
    }

    private String pairingVariantToString(int variant) {
        switch (variant) {
            case 0: {
                return "PAIRING_VARIANT_PIN";
            }
            case 1: {
                return "PAIRING_VARIANT_PASSKEY";
            }
            case 2: {
                return "PAIRING_VARIANT_PASSKEY_CONFIRMATION";
            }
            case 3: {
                return "PAIRING_VARIANT_CONSENT";
            }
            case 4: {
                return "PAIRING_VARIANT_DISPLAY_PASSKEY";
            }
            case 5: {
                return "PAIRING_VARIANT_DISPLAY_PIN";
            }
            case 6: {
                return "PAIRING_VARIANT_OOB_CONSENT";
            }
        }
        return "UNKNOWN";
    }

    private BluetoothGatt connectGattHelper(BluetoothDevice remoteDevice, boolean autoConnect, BluetoothGattCallback bluetoothGattCallback) {
        if (remoteDevice == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24 || !autoConnect) {
            return this.connectGattCompat(bluetoothGattCallback, remoteDevice, autoConnect);
        }
        try {
            Object iBluetoothGatt = this.getIBluetoothGatt(this.getIBluetoothManager());
            if (iBluetoothGatt == null) {
                Logger.e(TAG, "could not get iBluetoothGatt object");
                return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
            }
            BluetoothGatt bluetoothGatt = this.createBluetoothGatt(iBluetoothGatt, remoteDevice);
            if (bluetoothGatt == null) {
                Logger.e(TAG, "could not create BluetoothGatt object");
                return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
            }
            boolean connectedSuccessfully = this.connectUsingReflection(remoteDevice, bluetoothGatt, bluetoothGattCallback, true);
            if (!connectedSuccessfully) {
                Logger.i(TAG, "connection using reflection failed, closing gatt");
                bluetoothGatt.close();
            }
            return bluetoothGatt;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            Logger.e(TAG, "error during reflection");
            return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
        }
    }

    private BluetoothGatt connectGattCompat(BluetoothGattCallback bluetoothGattCallback, BluetoothDevice device, boolean autoConnect) {
        if (Build.VERSION.SDK_INT >= 23) {
            return device.connectGatt(this.context, autoConnect, bluetoothGattCallback, this.transport.value);
        }
        try {
            Method connectGattMethod = device.getClass().getMethod("connectGatt", Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE);
            try {
                return (BluetoothGatt)connectGattMethod.invoke((Object)device, this.context, autoConnect, bluetoothGattCallback, this.transport.value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return device.connectGatt(this.context, autoConnect, bluetoothGattCallback);
    }

    private boolean connectUsingReflection(BluetoothDevice device, BluetoothGatt bluetoothGatt, BluetoothGattCallback bluetoothGattCallback, boolean autoConnect) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        this.setAutoConnectValue(bluetoothGatt, autoConnect);
        Method connectMethod = bluetoothGatt.getClass().getDeclaredMethod("connect", Boolean.class, BluetoothGattCallback.class);
        connectMethod.setAccessible(true);
        return (Boolean)connectMethod.invoke((Object)bluetoothGatt, true, bluetoothGattCallback);
    }

    private BluetoothGatt createBluetoothGatt(Object iBluetoothGatt, BluetoothDevice remoteDevice) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<?> bluetoothGattConstructor = BluetoothGatt.class.getDeclaredConstructors()[0];
        bluetoothGattConstructor.setAccessible(true);
        if (bluetoothGattConstructor.getParameterTypes().length == 4) {
            return (BluetoothGatt)bluetoothGattConstructor.newInstance(this.context, iBluetoothGatt, remoteDevice, this.transport.value);
        }
        return (BluetoothGatt)bluetoothGattConstructor.newInstance(this.context, iBluetoothGatt, remoteDevice);
    }

    private Object getIBluetoothGatt(Object iBluetoothManager) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (iBluetoothManager == null) {
            return null;
        }
        Method getBluetoothGattMethod = this.getMethodFromClass(iBluetoothManager.getClass(), "getBluetoothGatt");
        return getBluetoothGattMethod.invoke(iBluetoothManager, new Object[0]);
    }

    private Object getIBluetoothManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return null;
        }
        Method getBluetoothManagerMethod = this.getMethodFromClass(bluetoothAdapter.getClass(), "getBluetoothManager");
        return getBluetoothManagerMethod.invoke((Object)bluetoothAdapter, new Object[0]);
    }

    private Method getMethodFromClass(Class<?> cls, String methodName) throws NoSuchMethodException {
        Method method = cls.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method;
    }

    private void setAutoConnectValue(BluetoothGatt bluetoothGatt, boolean autoConnect) throws NoSuchFieldException, IllegalAccessException {
        Field autoConnectField = bluetoothGatt.getClass().getDeclaredField("mAutoConnect");
        autoConnectField.setAccessible(true);
        autoConnectField.setBoolean(bluetoothGatt, autoConnect);
    }

    private void startConnectionTimer(final BluetoothPeripheral peripheral) {
        this.cancelConnectionTimer();
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                Logger.e(TAG, "connection timout, disconnecting '%s'", peripheral.getName());
                BluetoothPeripheral.this.disconnect();
                BluetoothPeripheral.this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothPeripheral.this.bluetoothGatt != null) {
                            BluetoothPeripheral.this.bluetoothGattCallback.onConnectionStateChange(BluetoothPeripheral.this.bluetoothGatt, HciStatus.CONNECTION_FAILED_ESTABLISHMENT.value, 0);
                        }
                    }
                }, 50L);
                BluetoothPeripheral.this.timeoutRunnable = null;
            }
        };
        this.mainHandler.postDelayed(this.timeoutRunnable, 35000L);
    }

    private void cancelConnectionTimer() {
        if (this.timeoutRunnable != null) {
            this.mainHandler.removeCallbacks(this.timeoutRunnable);
            this.timeoutRunnable = null;
        }
    }

    private int getTimoutThreshold() {
        String manufacturer = Build.MANUFACTURER;
        if (manufacturer.equalsIgnoreCase("samsung")) {
            return 4500;
        }
        return 25000;
    }

    byte[] copyOf(byte[] source) {
        return source == null ? new byte[]{} : Arrays.copyOf(source, source.length);
    }

    byte[] nonnullOf(byte[] source) {
        return source == null ? new byte[]{} : source;
    }

    static /* synthetic */ byte[] access$902(BluetoothPeripheral x0, byte[] x1) {
        x0.currentWriteBytes = x1;
        return x1;
    }

    static interface InternalCallback {
        public void connecting(BluetoothPeripheral var1);

        public void connected(BluetoothPeripheral var1);

        public void connectFailed(BluetoothPeripheral var1, HciStatus var2);

        public void disconnecting(BluetoothPeripheral var1);

        public void disconnected(BluetoothPeripheral var1, HciStatus var2);

        public String getPincode(BluetoothPeripheral var1);
    }
}

