/*
 * Decompiled with CFR 0.152.
 */
package com.peripheral.ble;

public enum CharacteristicProperty {
    UNKNOWN(-1),
    PROPERTY_BROADCAST(1),
    PROPERTY_EXTENDED_PROPS(128),
    PROPERTY_INDICATE(32),
    PROPERTY_NOTIFY(16),
    PROPERTY_READ(2),
    PROPERTY_SIGNED_WRITE(64),
    PROPERTY_WRITE(8),
    PROPERTY_WRITE_NO_RESPONSE(4);

    private int value;

    private CharacteristicProperty(int i) {
        this.value = i;
    }

    public static CharacteristicProperty fromValue(int value) {
        for (CharacteristicProperty type : CharacteristicProperty.values()) {
            if (type.value != value) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static boolean isWRITE(int value) {
        return (value & CharacteristicProperty.PROPERTY_WRITE.value) > 0;
    }

    public static boolean isWRITE_NO_RESPONSE(int value) {
        return (value & CharacteristicProperty.PROPERTY_WRITE_NO_RESPONSE.value) > 0;
    }

    public static boolean isREAD(int value) {
        return (value & CharacteristicProperty.PROPERTY_READ.value) > 0;
    }

    public static boolean isNOTIFY(int value) {
        return (value & CharacteristicProperty.PROPERTY_NOTIFY.value) > 0;
    }

    public static boolean isINDICATE(int value) {
        return (value & CharacteristicProperty.PROPERTY_INDICATE.value) > 0;
    }
}

