package com.pda.uhfdemo;
import com.pda.uhfdemo.utils.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.os.Bundle;
import android.util.Log;
import android.widget.Button;
import android.widget.Spinner;

import com.gg.reader.api.dal.GClient;
import com.gg.reader.api.protocol.gx.MsgBaseGetFreqRange;
import com.gg.reader.api.protocol.gx.MsgBaseGetFrequency;
import com.gg.reader.api.protocol.gx.MsgBaseSetFreqRange;
import com.gg.reader.api.protocol.gx.MsgBaseSetFrequency;
import com.gg.reader.api.protocol.gx.MsgBaseStop;
import com.gg.reader.api.utils.FrequencyUtils;
import com.pda.uhfdemo.adapter.FrequencyAdapter;
import com.pda.uhfdemo.utils.GlobalClient;
import com.pda.uhfdemo.utils.Toast;

import java.util.ArrayList;
import java.util.List;

public class FrequencyActivity extends AppCompatActivity {

    Spinner set_frequency_spinner;
    Spinner autoFreq_mode;
    RecyclerView autoFreq_recyclerview;
    Button autoFreq_query_btn;
    Button autoFreq_set_btn;

    GClient client = GlobalClient.getClient();
    FrequencyAdapter frequencyAdapter;

    List<PointInfo> frequencyList = new ArrayList<>();


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_frequency);

        set_frequency_spinner = findViewById(R.id.set_frequency_spinner);
        autoFreq_mode = findViewById(R.id.autoFreq_mode);
        autoFreq_recyclerview = findViewById(R.id.autoFreq_recyclerview);
        autoFreq_query_btn = findViewById(R.id.autoFreq_query_btn);
        autoFreq_set_btn = findViewById(R.id.autoFreq_set_btn);

        findViewById(R.id.frequency_query_btn).setOnClickListener(v -> frequencyQueryEvent());
        findViewById(R.id.frequency_set_btn).setOnClickListener(v -> frequencySetEvent());
        autoFreq_query_btn.setOnClickListener(v -> autoFrequencyQueryEvent());
        autoFreq_set_btn.setOnClickListener(v -> autoFrequencySetEvent());

        initAdapter();
        MsgBaseStop stop = new MsgBaseStop();
        client.sendSynMsg(stop, 1500);
        if (stop.getRtCode() == 0) {
            frequencyQueryEvent();
            autoFrequencyQueryEvent();
        }
    }


    private void initAdapter() {
        frequencyAdapter = new FrequencyAdapter(frequencyList);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        autoFreq_recyclerview.addItemDecoration(new DividerItemDecoration(this, 1));
        autoFreq_recyclerview.setLayoutManager(layoutManager);
        autoFreq_recyclerview.setAdapter(frequencyAdapter);
    }

    public void frequencyQueryEvent() {
        MsgBaseGetFreqRange msg = new MsgBaseGetFreqRange();
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            set_frequency_spinner.setSelection(msg.getFreqRangeIndex());
            frequencyList.clear();
            List<String> pointList = FrequencyUtils.indexGetFre(msg.getFreqRangeIndex());
            for (String point : pointList) {
                frequencyList.add(new PointInfo(false, point));
            }
            frequencyAdapter.notifyDataSetChanged();
        } else {
            Toast.show(msg.getRtMsg());
        }
    }

    public void frequencySetEvent() {
        MsgBaseSetFreqRange msg = new MsgBaseSetFreqRange();
        msg.setFreqRangeIndex(set_frequency_spinner.getSelectedItemPosition());
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            frequencyList.clear();
            List<String> pointList = FrequencyUtils.indexGetFre(msg.getFreqRangeIndex());
            for (String point : pointList) {
                frequencyList.add(new PointInfo(false, point));
            }
            frequencyAdapter.notifyDataSetChanged();
        }
        Toast.show(msg.getRtMsg());
    }


    public void autoFrequencyQueryEvent() {
        MsgBaseGetFrequency msg = new MsgBaseGetFrequency();
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            autoFreq_mode.setSelection(msg.getAutomatically() ? 1 : 0);
            for (PointInfo info : frequencyList) {
                info.setChecked(false);
            }
            for (int index : msg.getListFreqCursor()) {
                frequencyList.get(index).setChecked(true);
            }
            frequencyAdapter.notifyDataSetChanged();
        } else {
            Toast.show(msg.getRtMsg());
        }
    }


    public void autoFrequencySetEvent() {
        MsgBaseSetFrequency msg = new MsgBaseSetFrequency();
        msg.setAutomatically(autoFreq_mode.getSelectedItemPosition() == 1);
        if (!msg.getAutomatically()) {
            ArrayList<Integer> indexList = new ArrayList<>();
            for (int i = 0; i < frequencyList.size(); i++) {
                if (frequencyList.get(i).isChecked()) {
                    indexList.add(i);
                }
            }
            msg.setListFreqCursor(indexList);
        }
        client.sendSynMsg(msg);
        Toast.show(msg.getRtMsg());
    }

    public static class PointInfo {
        private boolean checked;
        private String text;

        public PointInfo(boolean checked, String text) {
            this.checked = checked;
            this.text = text;
        }

        public boolean isChecked() {
            return checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

}