package com.pda.uhfdemo;
import com.pda.uhfdemo.utils.DialogUtils;
import com.pda.uhfdemo.utils.Toast;


import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;

import com.gg.reader.api.dal.GClient;
import com.gg.reader.api.protocol.gx.EnumG;
import com.gg.reader.api.protocol.gx.MsgAppGetSerialParam;
import com.gg.reader.api.protocol.gx.MsgAppRestoreDefault;
import com.gg.reader.api.protocol.gx.MsgAppSetSerialParam;
import com.gg.reader.api.protocol.gx.MsgBaseGetAutoDormancy;
import com.gg.reader.api.protocol.gx.MsgBaseGetFreqRange;
import com.gg.reader.api.protocol.gx.MsgBaseGetTagLog;
import com.gg.reader.api.protocol.gx.MsgBaseSetAutoDormancy;
import com.gg.reader.api.protocol.gx.MsgBaseSetFreqRange;
import com.gg.reader.api.protocol.gx.MsgBaseSetTagLog;
import com.gg.reader.api.protocol.gx.MsgBaseStop;
import com.gg.reader.api.protocol.gx.MsgTestCarrierWave;
import com.gg.reader.api.protocol.gx.MsgTestVSWRcheck;
import com.gg.reader.api.utils.FrequencyUtils;
import com.gg.reader.api.utils.StringUtils;
import com.pda.uhfdemo.utils.GlobalClient;
import com.pda.uhfdemo.utils.LocalManageUtil;
import com.pda.uhfdemo.utils.Toast;
import com.tencent.mmkv.MMKV;

import androidx.appcompat.app.AppCompatActivity;

public class OtherActivity extends AppCompatActivity {

    Spinner set_auto_mode;
    EditText set_auto_freeTime;
    EditText filterTime;
    EditText rssiThreshold;
    Spinner set_frequency_spinner;
    Spinner set_baudRate_spinner;

    GClient client = GlobalClient.getClient();

    MMKV mmkv = MMKV.defaultMMKV();


    @SuppressLint("NonConstantResourceId")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_other);

        set_auto_mode = findViewById(R.id.set_auto_mode);
        set_auto_freeTime = findViewById(R.id.set_auto_freeTime);
        filterTime = findViewById(R.id.filterTime);
        rssiThreshold = findViewById(R.id.rssiThreshold);
        set_frequency_spinner = findViewById(R.id.set_frequency_spinner);
        set_baudRate_spinner = findViewById(R.id.set_baudRate_spinner);

        findViewById(R.id.auto_query_btn).setOnClickListener(v -> autoQueryEvent());
        findViewById(R.id.auto_set_btn).setOnClickListener(v -> autoSetEvent());
        findViewById(R.id.frequency_query_btn).setOnClickListener(v -> frequencyQueryEvent());
        findViewById(R.id.frequency_set_btn).setOnClickListener(v -> frequencySetEvent());
        findViewById(R.id.upload_query_btn).setOnClickListener(v -> uploadQueryEvent());
        findViewById(R.id.upload_set_btn).setOnClickListener(v -> uploadSetEvent());
        findViewById(R.id.reset_btn).setOnClickListener(v -> resetEvent());
        findViewById(R.id.baudRate_query_btn).setOnClickListener(v -> baudRateQueryEvent());
        findViewById(R.id.baudRate_set_btn).setOnClickListener(v -> baudRateSetEvent());

        initQuery();
    }


    public void initQuery() {
        MsgBaseStop stop = new MsgBaseStop();
        client.sendSynMsg(stop, 1500);
        if (stop.getRtCode() == 0) {
            autoQueryEvent();
            frequencyQueryEvent();
            uploadQueryEvent();
            baudRateQueryEvent();
        }
    }


    public void autoQueryEvent() {
        MsgBaseGetAutoDormancy msg = new MsgBaseGetAutoDormancy();
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            set_auto_mode.setSelection(msg.getOnOff());
            set_auto_freeTime.setText(msg.getFreeTime() + "");
        } else {
            Toast.show(msg.getRtMsg());
        }
    }

    public void autoSetEvent() {
        String freeTime = set_auto_freeTime.getText().toString();
        if (StringUtils.isNullOfEmpty(freeTime)) {
            Toast.show(getString(R.string.setting_hint_1));
            return;
        }
        MsgBaseSetAutoDormancy msg = new MsgBaseSetAutoDormancy();
        msg.setOnOff(set_auto_mode.getSelectedItemPosition());
        msg.setFreeTime(Integer.parseInt(freeTime));
        client.sendSynMsg(msg);
        Toast.show(msg.getRtMsg());
    }

    public void frequencyQueryEvent() {
        MsgBaseGetFreqRange msg = new MsgBaseGetFreqRange();
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            set_frequency_spinner.setSelection(msg.getFreqRangeIndex());
        } else {
            Toast.show(msg.getRtMsg());
        }
    }

    public void frequencySetEvent() {
        MsgBaseSetFreqRange msg = new MsgBaseSetFreqRange();
        msg.setFreqRangeIndex(set_frequency_spinner.getSelectedItemPosition());
        client.sendSynMsg(msg);
        Toast.show(msg.getRtMsg());

    }

    public void uploadQueryEvent() {
        MsgBaseGetTagLog msg = new MsgBaseGetTagLog();
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            filterTime.setText(msg.getRepeatedTime() + "");
            rssiThreshold.setText(msg.getRssiTV() + "");
        } else {
            Toast.show(msg.getRtMsg());
        }
    }

    public void uploadSetEvent() {
        MsgBaseSetTagLog msg = new MsgBaseSetTagLog();
        msg.setRepeatedTime(Integer.parseInt(filterTime.getText().toString()));
        msg.setRssiTV(Integer.parseInt(rssiThreshold.getText().toString()));
        client.sendSynMsg(msg);
        Toast.show(msg.getRtMsg());
    }



    public void resetEvent() {
        DialogUtils.showConfirmDialog(
            this,
            getString(R.string.other_hint1),
            getString(R.string.other_hint2),
            "Ok",
            () -> {
                MsgAppRestoreDefault msg = new MsgAppRestoreDefault();
                client.sendSynMsg(msg);
                Toast.show(msg.getRtMsg());
            }
        );
    }


    public void baudRateQueryEvent() {
        MsgAppGetSerialParam msg = new MsgAppGetSerialParam();
        client.sendSynMsg(msg);
        if (msg.getRtCode()==0){
            set_baudRate_spinner.setSelection(msg.getSerialBaudrate());
        } else {
            Toast.show(msg.getRtMsg());
        }
    }


    public void baudRateSetEvent () {
        MsgAppSetSerialParam msg = new MsgAppSetSerialParam();
        msg.setSerialBaudrate(set_baudRate_spinner.getSelectedItemPosition());
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            mmkv.encode("baudRate", set_baudRate_spinner.getSelectedItem().toString());
            
        } else {
            Toast.show(msg.getRtMsg());
        }
    }




    @Override
    protected void onDestroy() {
        super.onDestroy();
        client.sendUnsynMsg(new MsgBaseStop());
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(LocalManageUtil.setLocal(newBase));
    }

}