package com.pda.uhfdemo;
import com.pda.uhfdemo.utils.Toast;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;

import com.gg.reader.api.dal.GClient;
import com.gg.reader.api.protocol.gx.EnumG;
import com.gg.reader.api.protocol.gx.MsgBaseGetFreqRange;
import com.gg.reader.api.protocol.gx.MsgBaseSetFreqRange;
import com.gg.reader.api.protocol.gx.MsgBaseStop;
import com.gg.reader.api.protocol.gx.MsgTestCarrierWave;
import com.gg.reader.api.protocol.gx.MsgTestVSWRcheck;
import com.gg.reader.api.utils.FrequencyUtils;
import com.pda.uhfdemo.utils.GlobalClient;
import com.pda.uhfdemo.utils.Toast;

public class StandingWaveActivity extends AppCompatActivity {

    Spinner set_frequency_spinner;
    Spinner point_spinner;
    EditText prePower;
    EditText sufPower;

    GClient client = GlobalClient.getClient();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_standing_wave);

        set_frequency_spinner = findViewById(R.id.set_frequency_spinner);
        point_spinner = findViewById(R.id.point_spinner);
        prePower = findViewById(R.id.prePower);
        sufPower = findViewById(R.id.sufPower);

        findViewById(R.id.frequency_query_btn).setOnClickListener(v -> frequencyQueryEvent());
        findViewById(R.id.frequency_set_btn).setOnClickListener(v -> frequencySetEvent());
        findViewById(R.id.carrier_btn).setOnClickListener(v -> carrierEvent());
        findViewById(R.id.stopCarrier_btn).setOnClickListener(v -> stopCarrierEvent());
        findViewById(R.id.detection_btn).setOnClickListener(v -> detectionEvent());

        initQuery();
    }


    public void initQuery() {
        MsgBaseStop stop = new MsgBaseStop();
        client.sendSynMsg(stop, 1500);
        if (stop.getRtCode() == 0) {
            frequencyQueryEvent();
        }
    }


    public void frequencyQueryEvent() {
        MsgBaseGetFreqRange msg = new MsgBaseGetFreqRange();
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            set_frequency_spinner.setSelection(msg.getFreqRangeIndex());
            ArrayAdapter<String> freAdapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, FrequencyUtils.indexGetFre(msg.getFreqRangeIndex()));
            point_spinner.setAdapter(freAdapter);
        } else {
            Toast.show(msg.getRtMsg());
        }
    }

    public void frequencySetEvent() {
        MsgBaseSetFreqRange msg = new MsgBaseSetFreqRange();
        msg.setFreqRangeIndex(set_frequency_spinner.getSelectedItemPosition());
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            ArrayAdapter<String> freAdapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, FrequencyUtils.indexGetFre(msg.getFreqRangeIndex()));
            point_spinner.setAdapter(freAdapter);
        }
        Toast.show(msg.getRtMsg());

    }

    public void carrierEvent() {
        MsgTestCarrierWave msg = new MsgTestCarrierWave();
        msg.setAntennaNum(EnumG.AntennaNo_1);
        msg.setFreqCursor(point_spinner.getSelectedItemPosition());
        client.sendSynMsg(msg);
        if (msg.getRtCode() != 0) {
            Toast.show(msg.getRtMsg());
        }
    }

    public void stopCarrierEvent() {
        MsgBaseStop msg = new MsgBaseStop();
        client.sendSynMsg(msg);
        Toast.show(msg.getRtMsg());
    }

    public void detectionEvent() {
        MsgTestVSWRcheck msg = new MsgTestVSWRcheck();
        client.sendSynMsg(msg);
        if (msg.getRtCode() == 0) {
            prePower.setText(msg.getPreValue() + "");
            sufPower.setText(msg.getSufValue() + "");
        } else {
            Toast.show(msg.getRtMsg());
        }
    }


}