package com.pda.uhfdemo.fragment.sixc;
import com.pda.uhfdemo.utils.DialogUtils;
import com.pda.uhfdemo.utils.Toast;

import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.gg.reader.api.utils.StringUtils;
import com.pda.uhfdemo.R;
import com.pda.uhfdemo.adapter.BindAdapter;
import com.pda.uhfdemo.entity.BindInfo;
import com.pda.uhfdemo.entity.TagInfo;
import com.pda.uhfdemo.utils.Toast;
import com.tencent.mmkv.MMKV;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class BindFragment6c extends Fragment {

    private Spinner bind_epc;
    private EditText bind_name;
    private RecyclerView bindListView;

    MMKV mmkv = MMKV.defaultMMKV();

    BindAdapter bindAdapter;

    List<BindInfo> bindInfoList = new ArrayList<>();
    LinkedHashMap<String, BindInfo> bindMap = new LinkedHashMap<>();

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_bind_6c, container, false);
        
        bind_epc = view.findViewById(R.id.bind_epc);
        bind_name = view.findViewById(R.id.bind_name);
        bindListView = view.findViewById(R.id.bind_listView);
        
        // Setup click listeners
        view.findViewById(R.id.bind_event).setOnClickListener(v -> bindEvent());
        view.findViewById(R.id.bind_clean).setOnClickListener(v -> bindClean());
        
        initAdapter();
        Log.e("BindFragment","BindFragment");
        return view;
    }

    private void initAdapter() {
        if (mmkv.allKeys() != null) {
            for (String key : mmkv.allKeys()) {
                if (!key.startsWith("set")) {
                    bindMap.put(key, new BindInfo(key, mmkv.decodeString(key)));
                }
            }
        }
        bindInfoList.addAll(bindMap.values());
        bindAdapter = new BindAdapter(bindInfoList);
        LinearLayoutManager layoutManager = new LinearLayoutManager(getContext(), LinearLayoutManager.VERTICAL, false);
        layoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        bindListView.addItemDecoration(new DividerItemDecoration(getContext(), 1));
        bindListView.setLayoutManager(layoutManager);
        bindListView.setAdapter(bindAdapter);
    }


    @RequiresApi(api = Build.VERSION_CODES.N)
    public void setData(List<TagInfo> tagInfoList) {
        List<TagInfo> notEmptyList = tagInfoList.stream().filter(tagInfo -> !StringUtils.isNullOfEmpty(tagInfo.getEpc())).collect(Collectors.toList());
        List<String> collect = notEmptyList.stream().map(TagInfo::getEpc).collect(Collectors.toList());
        ArrayAdapter<String> adapter = new ArrayAdapter<String>(getContext(), android.R.layout.simple_spinner_item, collect);
//        Adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        bind_epc.setAdapter(adapter);
    }

    public void selectData(int position) {
        bind_epc.setSelection(position);
    }

    public void bindEvent() {
        if (bind_epc.getSelectedItem() == null) {
            Toast.show(getString(R.string.bind_hint_1));
            return;
        }
        if (StringUtils.isNullOfEmpty(bind_name.getText().toString())) {
            Toast.show(getString(R.string.bind_hint_2));
            return;
        }

        String epc = bind_epc.getSelectedItem().toString();
        String name = bind_name.getText().toString();
        mmkv.encode(epc, name);
        bindMap.put(epc, new BindInfo(epc, name));
        bindInfoList.clear();
        bindInfoList.addAll(bindMap.values());
        bindAdapter.notifyDataSetChanged();
        Toast.show(getString(R.string.bind_hint_3));
    }

    public void bindClean() {
        DialogUtils.showConfirmDialog(
            requireContext(),
            getString(R.string.bind_hint_4),
            getString(R.string.bind_hint_5),
            getString(R.string.bind_hint_6),
            () -> {
                if (mmkv.allKeys() != null) {
                    for (String key : mmkv.allKeys()) {
                        if (!key.startsWith("set")) {
                            mmkv.remove(key);
                        }
                    }
                }
                bindInfoList.clear();
                bindMap.clear();
                bindAdapter.notifyDataSetChanged();
            }
        );

    }

}