package com.pda.uhfdemo.init;
import com.pda.uhfdemo.utils.Toast;

import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.util.Log;


import com.gg.reader.api.dal.GClient;
import com.gg.reader.api.protocol.gx.MsgBaseStop;
import com.pda.uhfdemo.R;
import com.pda.uhfdemo.utils.EmulatorUtils;
import com.pda.uhfdemo.utils.GlobalClient;
import com.pda.uhfdemo.utils.LocalManageUtil;
import com.pda.uhfdemo.utils.PowerUtil;
import com.tencent.mmkv.MMKV;

public class AppInit extends Application {

    private static AppInit instance;
    GClient client = GlobalClient.getClient();
    
    public static Context getContext() {
        return instance;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        instance = this;
        String rootDir = MMKV.initialize(this);
        Log.e("mmkv root:", rootDir);
        
        // Check if running on emulator and skip SmartShow initialization
        if (EmulatorUtils.isEmulator()) {
            Log.d("AppInit", "Running on emulator - skipping SmartShow initialization");
        } else {
            Log.d("AppInit", "Running on real device - using standard Android components");
        }
        
        LocalManageUtil.setApplicationLanguage(this);
        AppStateTracker.track(this, new AppStateTracker.AppStateChangeListener() {
            @Override
            public void appTurnIntoForeground() {
                if (!EmulatorUtils.isEmulator()) {
                    PowerUtil.power("1");
                } else {
                    EmulatorUtils.logSkippedFeature("PowerUtil.power(1)");
                }
                init();
            }

            @Override
            public void appTurnIntoBackGround() {
                if (!EmulatorUtils.isEmulator()) {
                    PowerUtil.power("0");
                } else {
                    EmulatorUtils.logSkippedFeature("PowerUtil.power(0)");
                }
                client.close();
            }
        });
    }

    private void init() {
        int[] baudRateList = {460800, 115200};
        for (int i : baudRateList) {
            boolean b = openReader(i + "");
            if (b) {
                break;
            }
        }
    }


    private boolean openReader(String baudRate) {
        if (client.openAndroidSerial("/dev/ttyS3:" + baudRate, 0)) {
            MsgBaseStop stop = new MsgBaseStop();
            client.sendSynMsg(stop);
            if (stop.getRtCode() == 0) {
                return stop.getRtCode() == 0;
            } else {
                client.close();
            }
        } else {
            Toast.show(getString(R.string.toast_open_serial));
        }
        return false;
    }


    @Override
    protected void attachBaseContext(Context base) {
        LocalManageUtil.saveSystemCurrentLanguage(base);
        super.attachBaseContext(LocalManageUtil.setLocal(base));
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        LocalManageUtil.onConfigurationChanged(getApplicationContext());
    }
}
