package com.pda.uhfdemo.utils;

import android.content.Context;
import android.content.DialogInterface;

import androidx.appcompat.app.AlertDialog;

public class DialogUtils {
    
    public interface OnConfirmListener {
        void onConfirm();
    }
    
    public static void showConfirmDialog(Context context, String title, String message, 
                                       String confirmText, OnConfirmListener listener) {
        if (context == null) {
            return;
        }
        
        new AlertDialog.Builder(context)
                .setTitle(title)
                .setMessage(message)
                .setPositiveButton(confirmText, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        if (listener != null) {
                            listener.onConfirm();
                        }
                        dialog.dismiss();
                    }
                })
                .setNegativeButton(android.R.string.cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                })
                .show();
    }
    
    public static void showListDialog(Context context, String title, String[] items, 
                                    DialogInterface.OnClickListener listener) {
        if (context == null) {
            return;
        }
        
        new AlertDialog.Builder(context)
                .setTitle(title)
                .setItems(items, listener)
                .show();
    }
}
