package com.pda.uhfdemo.utils;

import android.os.Build;
import android.util.Log;

public class EmulatorUtils {
    
    private static final String TAG = "EmulatorUtils";
    private static Boolean isEmulator = null;
    
    /**
     * Check if the app is running on an emulator
     * @return true if running on emulator, false otherwise
     */
    public static boolean isEmulator() {
        if (isEmulator == null) {
            isEmulator = checkEmulator();
        }
        return isEmulator;
    }
    
    private static boolean checkEmulator() {
        boolean result = (Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic"))
                || Build.FINGERPRINT.startsWith("generic")
                || Build.FINGERPRINT.startsWith("unknown")
                || Build.HARDWARE.contains("goldfish")
                || Build.HARDWARE.contains("ranchu")
                || Build.MODEL.contains("google_sdk")
                || Build.MODEL.contains("Emulator")
                || Build.MODEL.contains("Android SDK built for x86")
                || Build.MANUFACTURER.contains("Genymotion")
                || Build.PRODUCT.contains("sdk_google")
                || Build.PRODUCT.contains("google_sdk")
                || Build.PRODUCT.contains("sdk")
                || Build.PRODUCT.contains("sdk_x86")
                || Build.PRODUCT.contains("vbox86p")
                || Build.PRODUCT.contains("emulator")
                || Build.PRODUCT.contains("simulator");
        
        Log.d(TAG, "Emulator detection result: " + result);
        Log.d(TAG, "Build info - Brand: " + Build.BRAND + ", Device: " + Build.DEVICE + ", Product: " + Build.PRODUCT);
        
        return result;
    }
    
    /**
     * Log a message when skipping functionality due to emulator
     * @param feature The feature being skipped
     */
    public static void logSkippedFeature(String feature) {
        Log.i(TAG, "Skipping feature '" + feature + "' - running on emulator");
    }
    
    /**
     * Show a toast message about emulator limitations
     * @param feature The feature that's not available
     */
    public static void showEmulatorLimitationToast(String feature) {
        Toast.show("Feature '" + feature + "' not available in emulator");
    }
}
