package com.pda.uhfdemo.utils;

import android.util.Log;
import com.gg.reader.api.dal.GClient;

public class GlobalClient {

    private GlobalClient() {

    }

    private enum Singleton {
        INSTANCE;

        private final GClient client;

        Singleton() {
            client = new GClient();
        }

        private GClient getInstance() {
            return client;
        }
    }

    public static GClient getClient() {
        GClient client = Singleton.INSTANCE.getInstance();
        
        // For emulator, we'll handle hardware operations at the fragment level
        // rather than wrapping the entire GClient to avoid method signature issues
        return client;
    }
}
