package com.pda.uhfdemo.utils;

import android.content.Context;
import android.util.Log;

import com.gg.reader.api.utils.StringUtils;
import com.pda.uhfdemo.init.AppInit;

public class Toast {

    private static final String TAG = "Toast";

    public static void show(String msg) {
        String message = StringUtils.isNullOfEmpty(msg) ? "timeout" : msg;
        showStandardToast(message);
    }
    
    private static void showStandardToast(String message) {
        try {
            Context context = AppInit.getContext();
            if (context != null) {
                android.widget.Toast.makeText(context, message, android.widget.Toast.LENGTH_SHORT).show();
            } else {
                Log.e(TAG, "Cannot show toast - no context available: " + message);
            }
        } catch (Exception e) {
            Log.e(TAG, "Failed to show standard toast: " + message, e);
        }
    }
}
